/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenRevokeKycTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenRevokeKycUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenRevokeKycFromAccountHandler
implements TransactionHandler {
    @Inject
    public TokenRevokeKycFromAccountHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenRevokeKycTransactionBody op = context.body().tokenRevokeKycOrThrow();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(op.tokenOrElse(TokenID.DEFAULT));
        if (tokenMeta == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (!tokenMeta.hasKycKey()) {
            throw new PreCheckException(ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY);
        }
        context.requireKey(tokenMeta.kycKey());
    }

    public void handle(@NonNull HandleContext handleContext) {
        Objects.requireNonNull(handleContext);
        TokenRevokeKycTransactionBody op = handleContext.body().tokenRevokeKycOrThrow();
        TokenID tokenId = op.tokenOrThrow();
        AccountID accountId = op.accountOrElse(AccountID.DEFAULT);
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        ExpiryValidator expiryValidator = handleContext.expiryValidator();
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        TokenRelation tokenRel = this.validateSemantics(accountId, tokenId, tokenRelStore, accountStore, expiryValidator, tokenStore);
        TokenRelation.Builder tokenRelBuilder = tokenRel.copyBuilder();
        tokenRelBuilder.kycGranted(false);
        tokenRelStore.put(tokenRelBuilder.build());
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenRevokeKycTransactionBody op = txn.tokenRevokeKycOrThrow();
        if (!op.hasToken()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (!op.hasAccount()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    @NonNull
    private TokenRelation validateSemantics(@NonNull AccountID accountId, @NonNull TokenID tokenId, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ReadableTokenStore tokenStore) throws HandleException {
        TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        return TokenHandlerHelper.getIfUsable(accountId, tokenId, tokenRelStore);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj));
    }

    public FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        TokenRevokeKycUsage estimate = TokenRevokeKycUsage.newEstimate((com.hederahashgraph.api.proto.java.TransactionBody)txn, (TxnUsageEstimator)CryptoOpsUsage.txnEstimateFactory.get(sigUsage, txn, (EstimatorUtils)SingletonEstimatorUtils.ESTIMATOR_UTILS));
        return estimate.get();
    }
}

