/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.model.WiringModelBuilder;
import com.swirlds.component.framework.model.diagram.HyperlinkBuilder;
import com.swirlds.component.framework.model.internal.monitor.HealthMonitor;
import com.swirlds.component.framework.model.internal.standard.HeartbeatScheduler;
import com.swirlds.component.framework.model.internal.standard.JvmAnchor;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.builders.internal.StandardTaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.internal.SequentialThreadTaskScheduler;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;

public class StandardWiringModel
extends TraceableWiringModel {
    private final Metrics metrics;
    private final Time time;
    private HeartbeatScheduler heartbeatScheduler = null;
    private final TaskScheduler<Duration> healthMonitorScheduler;
    private HealthMonitor healthMonitor;
    private final BindableInputWire<Instant, Duration> healthMonitorInputWire;
    private final List<SequentialThreadTaskScheduler<?>> threadSchedulers = new ArrayList();
    private final ForkJoinPool defaultPool;
    private final JvmAnchor anchor;
    private final Duration healthLogThreshold;
    private final Duration healthLogPeriod;
    private final Duration healthyReportThreshold;
    private final Thread.UncaughtExceptionHandler taskSchedulerExceptionHandler;

    StandardWiringModel(@NonNull WiringModelBuilder builder) {
        super(builder.isHardBackpressureEnabled());
        this.metrics = Objects.requireNonNull(builder.getMetrics());
        this.time = Objects.requireNonNull(builder.getTime());
        this.defaultPool = Objects.requireNonNull(builder.getDefaultPool());
        TaskSchedulerBuilder healthMonitorSchedulerBuilder = this.schedulerBuilder("HealthMonitor");
        healthMonitorSchedulerBuilder.withHyperlink(HyperlinkBuilder.platformCoreHyperlink(HealthMonitor.class));
        if (builder.isHealthMonitorEnabled()) {
            healthMonitorSchedulerBuilder.withType(TaskSchedulerType.SEQUENTIAL).withUnhandledTaskMetricEnabled(true).withUnhandledTaskCapacity(builder.getHealthMonitorCapacity());
        } else {
            healthMonitorSchedulerBuilder.withType(TaskSchedulerType.NO_OP);
        }
        this.healthLogThreshold = builder.getHealthLogThreshold();
        this.healthLogPeriod = builder.getHealthLogPeriod();
        this.healthyReportThreshold = builder.getHealthyReportThreshold();
        this.healthMonitorScheduler = healthMonitorSchedulerBuilder.build();
        this.healthMonitorInputWire = this.healthMonitorScheduler.buildInputWire("check system health");
        this.buildHeartbeatWire(builder.getHealthMonitorPeriod()).solderTo(this.healthMonitorInputWire);
        this.anchor = builder.isJvmAnchorEnabled() ? new JvmAnchor() : null;
        this.taskSchedulerExceptionHandler = builder.getTaskSchedulerExceptionHandler();
    }

    @Override
    @NonNull
    public final <O> TaskSchedulerBuilder<O> schedulerBuilder(@NonNull String name) {
        this.throwIfStarted();
        StandardTaskSchedulerBuilder builder = new StandardTaskSchedulerBuilder(this.time, this.metrics, this, name, this.defaultPool);
        if (this.taskSchedulerExceptionHandler != null) {
            builder.withUncaughtExceptionHandler(this.taskSchedulerExceptionHandler);
        }
        return builder;
    }

    @Override
    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(@NonNull Duration period) {
        this.throwIfStarted();
        return this.getHeartbeatScheduler().buildHeartbeatWire(period, this.getHeartbeatExceptionHandler());
    }

    @Override
    @NonNull
    public OutputWire<Duration> getHealthMonitorWire() {
        return this.healthMonitorScheduler.getOutputWire();
    }

    @Override
    @NonNull
    public Duration getUnhealthyDuration() {
        this.throwIfNotStarted();
        return this.healthMonitor.getUnhealthyDuration();
    }

    @Override
    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(double frequency) {
        this.throwIfStarted();
        return this.getHeartbeatScheduler().buildHeartbeatWire(frequency, this.getHeartbeatExceptionHandler());
    }

    @Override
    public void registerScheduler(@NonNull TaskScheduler<?> scheduler, @Nullable String hyperlink) {
        super.registerScheduler(scheduler, hyperlink);
        if (scheduler.getType() == TaskSchedulerType.SEQUENTIAL_THREAD) {
            this.threadSchedulers.add((SequentialThreadTaskScheduler)scheduler);
        }
    }

    @NonNull
    private Thread.UncaughtExceptionHandler getHeartbeatExceptionHandler() {
        return Optional.ofNullable(this.taskSchedulerExceptionHandler).orElse(ExceptionHandlers.defaultExceptionHandler("Heartbeat"));
    }

    @Override
    public void start() {
        this.throwIfStarted();
        if (this.anchor != null) {
            this.anchor.start();
        }
        this.healthMonitor = new HealthMonitor(this.metrics, this.time, this.schedulers, this.healthLogThreshold, this.healthLogPeriod, this.healthyReportThreshold);
        this.healthMonitorInputWire.bind(this.healthMonitor::checkSystemHealth);
        this.markAsStarted();
        this.checkForCyclicalBackpressure();
        this.checkForIllegalDirectSchedulerUsage();
        this.checkForUnboundInputWires();
        if (this.heartbeatScheduler != null) {
            this.heartbeatScheduler.start();
        }
        for (SequentialThreadTaskScheduler<?> threadScheduler : this.threadSchedulers) {
            threadScheduler.start();
        }
    }

    @Override
    public void stop() {
        this.throwIfNotStarted();
        if (this.heartbeatScheduler != null) {
            this.heartbeatScheduler.stop();
        }
        for (SequentialThreadTaskScheduler<?> threadScheduler : this.threadSchedulers) {
            threadScheduler.stop();
        }
        if (this.anchor != null) {
            this.anchor.stop();
        }
    }

    @NonNull
    private HeartbeatScheduler getHeartbeatScheduler() {
        if (this.heartbeatScheduler == null) {
            this.heartbeatScheduler = new HeartbeatScheduler(this, this.time);
        }
        return this.heartbeatScheduler;
    }
}

