/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Mappers;
import io.helidon.service.registry.Services;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class GlobalManager {
    private static final System.Logger LOGGER = System.getLogger(GlobalManager.class.getName());
    private static final AtomicBoolean LOGGED_REGISTERED = new AtomicBoolean(false);
    private static final AtomicReference<MapperManager> MANAGER = new AtomicReference();

    private GlobalManager() {
    }

    static void mapperManager(MapperManager manager) {
        block2: {
            MANAGER.set(manager);
            try {
                Services.set(Mappers.class, (Object[])new Mappers[]{manager});
            }
            catch (Exception e) {
                if (!LOGGED_REGISTERED.compareAndSet(false, true)) break block2;
                LOGGER.log(System.Logger.Level.WARNING, "Attempting to set a Mappers (MapperManager) instance when it either was already set once, or it was already used by a component. This will not work in future versions of Helidon", (Throwable)e);
            }
        }
    }

    static MapperManager mapperManager() {
        MapperManager mapperManager = MANAGER.get();
        return mapperManager == null ? (MapperManager)Services.get(MapperManager.class) : mapperManager;
    }
}

