/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.stream.internal.AbstractLinkedObjectStream;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.logging.legacy.LogMarker;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.base.crypto.SerializableHashable;

public class HashCalculatorForStream<T extends RunningHashable & SerializableHashable>
extends AbstractLinkedObjectStream<T> {
    private static final Logger logger = LogManager.getLogger(HashCalculatorForStream.class);
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();

    public HashCalculatorForStream() {
    }

    public HashCalculatorForStream(LinkedObjectStream<T> nextStream) {
        super(nextStream);
    }

    @Override
    public void addObject(T t) {
        if (((SerializableHashable)((RunningHashable)Objects.requireNonNull(t))).getHash() == null) {
            CRYPTOGRAPHY.digestSync((SerializableHashable)t);
        }
        super.addObject(t);
    }

    @Override
    public void close() {
        super.close();
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "HashCalculatorForStream is closed");
    }
}

