/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.merkle.StateMetrics;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateLifecycleManagerImpl
implements StateLifecycleManager {
    private static final Logger log = LogManager.getLogger(StateLifecycleManagerImpl.class);
    private final StateMetrics stateMetrics;
    private final MerkleRootSnapshotMetrics snapshotMetrics;
    private final Time time;
    private final Metrics metrics;
    private final Function<VirtualMap, MerkleNodeState> stateSupplier;
    private final AtomicReference<MerkleNodeState> stateRef = new AtomicReference();
    private final AtomicReference<MerkleNodeState> latestImmutableStateRef = new AtomicReference();
    @NonNull
    private final Configuration configuration;

    public StateLifecycleManagerImpl(@NonNull Metrics metrics, @NonNull Time time, @NonNull Function<VirtualMap, MerkleNodeState> stateSupplier, @NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
        this.stateSupplier = stateSupplier;
        this.stateMetrics = new StateMetrics(metrics);
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
    }

    public MerkleNodeState createStateFrom(@NonNull MerkleNode rootNode) {
        return this.stateSupplier.apply((VirtualMap)rootNode);
    }

    public void initState(@NonNull MerkleNodeState state) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        if (this.stateRef.get() != null) {
            throw new IllegalStateException("Attempt to set initial state when there is already a state reference.");
        }
        this.copyAndUpdateStateRefs(state);
    }

    public void initStateOnReconnect(@NonNull MerkleNodeState state) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("rootNode must not be destroyed");
        state.throwIfImmutable("rootNode must be mutable");
        this.copyAndUpdateStateRefs(state);
    }

    @NonNull
    public MerkleNodeState getMutableState() {
        MerkleNodeState mutableState = this.stateRef.get();
        if (mutableState == null) {
            throw new IllegalStateException("StateLifecycleManager has not been initialized.");
        }
        return mutableState;
    }

    @NonNull
    public MerkleNodeState getLatestImmutableState() {
        MerkleNodeState latestImmutableState = this.latestImmutableStateRef.get();
        if (latestImmutableState == null) {
            throw new IllegalStateException("StateLifecycleManager has not been initialized.");
        }
        return latestImmutableState;
    }

    @NonNull
    public MerkleNodeState copyMutableState() {
        MerkleNodeState state = this.stateRef.get();
        this.copyAndUpdateStateRefs(state);
        return this.stateRef.get();
    }

    private void copyAndUpdateStateRefs(@NonNull MerkleNodeState stateToCopy) {
        long copyStart = System.nanoTime();
        MerkleNodeState newMutableState = stateToCopy.copy();
        newMutableState.getRoot().reserve();
        long copyEnd = System.nanoTime();
        this.stateMetrics.stateCopyMicros((double)(copyEnd - copyStart) * 0.001);
        State previousImmutableState = (State)this.latestImmutableStateRef.get();
        if (previousImmutableState != null) {
            assert (!previousImmutableState.isDestroyed());
            if (previousImmutableState.isDestroyed()) {
                log.error(LogMarker.EXCEPTION.getMarker(), "previousImmutableState is in destroyed state", (Throwable)new Exception());
            } else {
                previousImmutableState.release();
            }
        }
        stateToCopy.getRoot().reserve();
        this.latestImmutableStateRef.set(stateToCopy);
        MerkleNodeState previousMutableState = this.stateRef.get();
        if (previousMutableState != null) {
            assert (!previousMutableState.isDestroyed());
            if (previousMutableState.isDestroyed()) {
                log.error(LogMarker.EXCEPTION.getMarker(), "previousMutableState is in destroyed state", (Throwable)new Exception());
            } else {
                previousMutableState.release();
            }
        }
        this.stateRef.set(newMutableState);
    }

    public void createSnapshot(@NonNull MerkleNodeState state, @NonNull Path targetPath) {
        state.throwIfMutable();
        state.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        try {
            log.info(LogMarker.STATE_TO_DISK.getMarker(), "Creating a snapshot on demand in {} for {}", (Object)targetPath, (Object)state);
            VirtualMap virtualMap = (VirtualMap)state.getRoot();
            virtualMap.createSnapshot(targetPath);
            log.info(LogMarker.STATE_TO_DISK.getMarker(), "Successfully created a snapshot on demand in {}  for {}", (Object)targetPath, (Object)state);
        }
        catch (Throwable e) {
            log.error(LogMarker.EXCEPTION.getMarker(), "Unable to write a snapshot on demand for {} to {}.", (Object)state, (Object)targetPath, (Object)e);
        }
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    @NonNull
    public MerkleNodeState loadSnapshot(@NonNull Path targetPath) throws IOException {
        VirtualMap virtualMap;
        if (VirtualMap.isOldFormat((Path)targetPath)) {
            log.info(LogMarker.STARTUP.getMarker(), "Loading pre-0.70 snapshot from disk {}", (Object)targetPath);
            virtualMap = (VirtualMap)MerkleTreeSnapshotReader.readStateFileData((Path)targetPath);
        } else {
            log.info(LogMarker.STARTUP.getMarker(), "Loading snapshot from disk {}", (Object)targetPath);
            virtualMap = VirtualMap.loadFromDirectory((Path)targetPath, (Configuration)this.configuration, () -> new MerkleDbDataSourceBuilder(this.configuration));
        }
        VirtualMap mutableCopy = virtualMap.copy();
        mutableCopy.registerMetrics(this.metrics);
        virtualMap.release();
        return this.stateSupplier.apply(mutableCopy);
    }
}

