/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCreateOperation;

public class CreateOperation
extends AbstractCreateOperation {
    public CreateOperation(GasCalculator gasCalculator) {
        super(240, "CREATE", 3, 1, gasCalculator, 0);
    }

    @Override
    public long cost(MessageFrame frame, Supplier<Code> unused) {
        int inputOffset = Words.clampedToInt(frame.getStackItem(1));
        int inputSize = Words.clampedToInt(frame.getStackItem(2));
        return Words.clampedAdd(Words.clampedAdd(this.gasCalculator().txCreateCost(), this.gasCalculator().memoryExpansionGasCost(frame, inputOffset, inputSize)), this.gasCalculator().initcodeCost(inputSize));
    }

    @Override
    protected Address generateTargetContractAddress(MessageFrame frame, Code initcode) {
        Account sender = frame.getWorldUpdater().get(frame.getRecipientAddress());
        return Address.contractAddress((Address)frame.getRecipientAddress(), (long)(sender.getNonce() - 1L));
    }

    @Override
    protected Code getInitCode(MessageFrame frame, EVM evm) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(1));
        long inputSize = Words.clampedToLong(frame.getStackItem(2));
        Bytes inputData = frame.readMemory(inputOffset, inputSize);
        return evm.getCodeUncached(inputData);
    }
}

