/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.Fq;

public abstract class AbstractFqp<T extends AbstractFqp>
implements FieldElement<T> {
    private static final BigInteger BIGINT_2 = BigInteger.valueOf(2L);
    protected final int degree;
    protected final Fq[] modulusCoefficients;
    protected final Fq[] coefficients;

    protected AbstractFqp(int degree, Fq[] modulusCoefficients, Fq[] coefficients) {
        if (degree != coefficients.length) {
            throw new IllegalArgumentException(String.format("point is %d degree but got %d coefficients", degree, coefficients.length));
        }
        if (degree != modulusCoefficients.length) {
            throw new IllegalArgumentException(String.format("point is %d degree but got %d modulus coefficients", degree, coefficients.length));
        }
        this.degree = degree;
        this.modulusCoefficients = modulusCoefficients;
        this.coefficients = coefficients;
    }

    protected abstract T newInstance(Fq[] var1);

    public Fq[] getCoefficients() {
        return this.coefficients;
    }

    @Override
    public boolean isValid() {
        for (Fq fq : this.coefficients) {
            if (fq.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isZero() {
        for (Fq fq : this.coefficients) {
            if (fq.isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public T add(T other) {
        Fq[] result = new Fq[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            result[i] = this.coefficients[i].add(((AbstractFqp)other).coefficients[i]);
        }
        return this.newInstance(result);
    }

    @Override
    public T subtract(T other) {
        Fq[] result = new Fq[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            result[i] = this.coefficients[i].subtract(((AbstractFqp)other).coefficients[i]);
        }
        return this.newInstance(result);
    }

    @Override
    public T multiply(int n) {
        Fq[] result = new Fq[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            result[i] = this.coefficients[i].multiply(n);
        }
        return this.newInstance(result);
    }

    @Override
    public T multiply(T other) {
        int i;
        Object[] b = new Fq[this.degree * 2 - 1];
        Arrays.fill(b, Fq.zero());
        for (i = 0; i < this.degree; ++i) {
            for (int j = 0; j < this.degree; ++j) {
                b[i + j] = ((Fq)b[i + j]).add(this.coefficients[i].multiply(((AbstractFqp)other).coefficients[j]));
            }
        }
        for (i = b.length; i > this.degree; --i) {
            Object top = b[i - 1];
            int exp = i - this.degree - 1;
            for (int j = 0; j < this.degree; ++j) {
                b[exp + j] = ((Fq)b[exp + j]).subtract(((Fq)top).multiply(this.modulusCoefficients[j]));
            }
        }
        return this.newInstance((Fq[])Arrays.copyOfRange(b, 0, this.degree));
    }

    @Override
    public T divide(T other) {
        T inverse = this.newInstance(((AbstractFqp)other).inverse());
        return this.multiply(inverse);
    }

    @Override
    public T negate() {
        Fq[] negated = (Fq[])Arrays.stream(this.coefficients).map(Fq::negate).toArray(Fq[]::new);
        return this.newInstance(negated);
    }

    private T one() {
        Object[] result = new Fq[this.degree];
        Arrays.fill(result, Fq.zero());
        result[0] = Fq.one();
        return this.newInstance((Fq[])result);
    }

    @Override
    public T power(int n) {
        if (n == 0) {
            return this.one();
        }
        if (n == 1) {
            return this.newInstance(this.coefficients);
        }
        if (n % 2 == 0) {
            return (T)this.multiply((T)this).power(n / 2);
        }
        return (T)((AbstractFqp)this.multiply((T)this).power(n / 2)).multiply((T)this);
    }

    @Override
    public T power(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) == 0) {
            return this.one();
        }
        if (n.compareTo(BigInteger.ONE) == 0) {
            return (T)this;
        }
        if (n.mod(BIGINT_2).compareTo(BigInteger.ZERO) == 0) {
            return (T)this.multiply((T)this).power(n.divide(BIGINT_2));
        }
        return (T)((AbstractFqp)this.multiply((T)this).power(n.divide(BIGINT_2))).multiply((T)this);
    }

    protected Fq[] inverse() {
        Fq[] lm = this.lm();
        Fq[] hm = this.hm();
        Fq[] low = this.low();
        Fq[] high = this.high();
        while (AbstractFqp.deg(low) > 0) {
            Fq[] r = AbstractFqp.polyRoundedDiv(high, low);
            Fq[] nm = Arrays.copyOf(hm, hm.length);
            Fq[] neww = Arrays.copyOf(high, high.length);
            for (int i = 0; i < this.degree + 1; ++i) {
                for (int j = 0; j < this.degree + 1 - i; ++j) {
                    nm[i + j] = nm[i + j].subtract(lm[i].multiply(r[j]));
                    neww[i + j] = neww[i + j].subtract(low[i].multiply(r[j]));
                }
            }
            high = low;
            hm = lm;
            low = neww;
            lm = nm;
        }
        for (int i = 0; i < lm.length; ++i) {
            lm[i] = lm[i].divide(low[0]);
        }
        return Arrays.copyOfRange(lm, 0, this.degree);
    }

    private static Fq[] polyRoundedDiv(Fq[] a, Fq[] b) {
        int degA = AbstractFqp.deg(a);
        int degB = AbstractFqp.deg(b);
        Fq[] temp = Arrays.copyOf(a, a.length);
        Object[] o = new Fq[a.length];
        Arrays.fill(o, Fq.zero());
        for (int i = degA - degB; i >= 0; --i) {
            o[i] = ((Fq)o[i]).add(temp[degB + i].divide(b[degB]));
            for (int j = 0; j <= degB; ++j) {
                temp[i + j] = temp[i + j].subtract((Fq)o[j]);
            }
        }
        return o;
    }

    private static int deg(Fq[] p) {
        int d;
        for (d = p.length - 1; d >= 0 && p[d].equals(Fq.zero()); --d) {
        }
        return d;
    }

    private Fq[] lm() {
        Object[] lm = new Fq[this.degree + 1];
        Arrays.fill(lm, Fq.zero());
        lm[0] = Fq.one();
        return lm;
    }

    private Fq[] hm() {
        Object[] hm = new Fq[this.degree + 1];
        Arrays.fill(hm, Fq.zero());
        return hm;
    }

    private Fq[] low() {
        Fq[] low = Arrays.copyOfRange(this.coefficients, 0, this.coefficients.length + 1);
        low[low.length - 1] = Fq.zero();
        return low;
    }

    private Fq[] high() {
        Fq[] high = Arrays.copyOfRange(this.modulusCoefficients, 0, this.modulusCoefficients.length + 1);
        high[high.length - 1] = Fq.one();
        return high;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractFqp)) {
            return false;
        }
        AbstractFqp other = (AbstractFqp)obj;
        if (this.degree != other.degree) {
            return false;
        }
        if (!Arrays.equals(this.modulusCoefficients, other.modulusCoefficients)) {
            return false;
        }
        return Arrays.equals(this.coefficients, other.coefficients);
    }

    public int hashCode() {
        return Objects.hash(this.degree, Arrays.hashCode(this.modulusCoefficients), Arrays.hashCode(this.coefficients));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("coefficients", (Object)this.coefficients).toString();
    }
}

