/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.http.http2.Http2ConnectionWriter;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2GoAway;
import io.helidon.http.http2.Http2Settings;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2Connection;

class Http2ConnectionChecks {
    private static final System.Logger LOGGER = System.getLogger(Http2ConnectionChecks.class.getName());
    private final Http2Settings clientSettings = Http2Settings.builder().build();
    private final Http2ConnectionWriter writer;
    private final Http2Connection connection;
    private final long rapidResetCheckPeriod;
    private final int maxRapidResets;
    private int rapidResetCnt = 0;
    private long rapidResetPeriodStart = 0L;
    private long serverSideResetCounter = 0L;

    Http2ConnectionChecks(Http2Config http2Config, Http2ConnectionWriter connectionWriter, Http2Connection connection) {
        this.rapidResetCheckPeriod = http2Config.rapidResetCheckPeriod().toNanos();
        this.maxRapidResets = http2Config.maxRapidResets();
        this.writer = connectionWriter;
        this.connection = connection;
    }

    void rapidResetCheck(boolean rapidReset) {
        if (rapidReset && this.maxRapidResets != -1) {
            long currentTime = System.nanoTime();
            if (this.rapidResetCheckPeriod >= currentTime - this.rapidResetPeriodStart) {
                this.rapidResetCnt = 1;
                this.rapidResetPeriodStart = currentTime;
            } else if (this.maxRapidResets < this.rapidResetCnt) {
                this.closeConnection("Rapid reset attack detected!");
            } else {
                ++this.rapidResetCnt;
            }
        }
    }

    void madeYouResetCheck(int lastStreamId) {
        if (this.serverSideResetCounter++ > (long)this.maxRapidResets && this.serverSideResetCounter > (long)(lastStreamId / 4)) {
            this.closeConnection("MadeYouReset attack detected!");
        }
    }

    private void closeConnection(String msg) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, msg + " Closing connection " + String.valueOf(this.connection) + " with GOAWAY");
        }
        Http2GoAway frame = new Http2GoAway(0, Http2ErrorCode.ENHANCE_YOUR_CALM, msg);
        this.writer.write(frame.toFrameData(this.clientSettings, 0, Http2Flag.NoFlags.create()));
        this.connection.finish();
        this.connection.close(true);
        throw new Http2Exception(Http2ErrorCode.ENHANCE_YOUR_CALM, msg);
    }
}

