/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeResponse;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public class LearnerPullVirtualTreeReceiveTask {
    private static final Logger logger = LogManager.getLogger(LearnerPullVirtualTreeReceiveTask.class);
    private static final String NAME = "reconnect-learner-receiver";
    private final StandardWorkGroup workGroup;
    private final SerializableDataInputStream in;
    private final LearnerPullVirtualTreeView view;
    private final AtomicBoolean senderIsFinished;
    private final AtomicLong expectedResponses;
    private final CountDownLatch rootResponseReceived;

    public LearnerPullVirtualTreeReceiveTask(StandardWorkGroup workGroup, SerializableDataInputStream in, LearnerPullVirtualTreeView view, AtomicBoolean senderIsFinished, AtomicLong expectedResponses, CountDownLatch rootResponseReceived) {
        this.workGroup = workGroup;
        this.in = in;
        this.view = view;
        this.senderIsFinished = senderIsFinished;
        this.expectedResponses = expectedResponses;
        this.rootResponseReceived = rootResponseReceived;
    }

    public void exec() {
        this.workGroup.execute(NAME, this::run);
    }

    private void run() {
        try (LearnerPullVirtualTreeView learnerPullVirtualTreeView = this.view;){
            boolean responseExpected;
            boolean finished = this.senderIsFinished.get();
            boolean bl = responseExpected = this.expectedResponses.get() > 0L;
            while (!finished || responseExpected) {
                if (responseExpected) {
                    PullVirtualTreeResponse response = new PullVirtualTreeResponse(this.view);
                    response.deserialize(this.in, 0);
                    this.view.getMapStats().incrementTransfersFromTeacher();
                    logger.debug(LogMarker.RECONNECT.getMarker(), "Learner receive path: " + response.getPath());
                    if (response.getPath() == 0L) {
                        this.rootResponseReceived.countDown();
                    }
                    this.expectedResponses.decrementAndGet();
                } else {
                    Thread.onSpinWait();
                }
                finished = this.senderIsFinished.get();
                responseExpected = this.expectedResponses.get() > 0L;
            }
            logger.debug(LogMarker.RECONNECT.getMarker(), "Learner receive done");
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("Exception in the learner's receiving task", (Throwable)ex);
        }
    }
}

