/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.defaultfreezestatus;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.defaultfreezestatus.DefaultFreezeStatusCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultFreezeStatusTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod DEFAULT_FREEZE_STATUS = SystemContractMethod.declare("getTokenDefaultFreezeStatus(address)", "(int32,bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategory(SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public DefaultFreezeStatusTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(DEFAULT_FREEZE_STATUS);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(DEFAULT_FREEZE_STATUS);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Tuple args = DEFAULT_FREEZE_STATUS.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new DefaultFreezeStatusCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.isStaticCall(), token);
    }
}

