/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ownerof;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNftViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ownerof.OwnerOfTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;

public class OwnerOfCall
extends AbstractNftViewCall {
    private static final long TREASURY_OWNER_NUM = 0L;

    public OwnerOfCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, long serialNo) {
        super(gasCalculator, enhancement, token, serialNo);
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingNft(@NonNull Token token, @NonNull Nft nft) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(nft);
        long ownerNum = this.getOwnerAccountNum(nft, token);
        long gasRequirement = this.gasCalculator.viewGasRequirement();
        Account owner = this.nativeOperations().getAccount(this.enhancement.nativeOperations().entityIdFactory().newAccountId(ownerNum));
        if (owner == null) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_ACCOUNT_ID, gasRequirement), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        ByteBuffer output = OwnerOfTranslator.OWNER_OF.getOutputs().encode((Object)Tuple.singleton((Object)ConversionUtils.headlongAddressOf(owner)));
        return Call.PricedResult.gasOnly(FullResult.successResult(output, gasRequirement), ResponseCodeEnum.SUCCESS, true);
    }

    @Override
    protected ResponseCodeEnum missingNftStatus() {
        return ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER;
    }

    private long getOwnerAccountNum(@NonNull Nft nft, @NonNull Token token) {
        AccountID explicitId = nft.ownerIdOrElse(AccountID.DEFAULT);
        if (explicitId.accountNumOrElse(Long.valueOf(0L)) == 0L) {
            return token.treasuryAccountIdOrThrow().accountNumOrThrow();
        }
        return explicitId.accountNumOrThrow();
    }
}

