/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.WritableRosterStore;

public final class RosterStateUtils {
    private RosterStateUtils() {
    }

    @NonNull
    public static RosterHistory createRosterHistory(@NonNull State state) {
        ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
        List<RoundRosterPair> roundRosterPairs = rosterStore.getRosterHistory();
        HashMap<Bytes, Roster> rosterMap = new HashMap<Bytes, Roster>();
        for (RoundRosterPair pair : roundRosterPairs) {
            rosterMap.put(pair.activeRosterHash(), Objects.requireNonNull(rosterStore.get(pair.activeRosterHash())));
        }
        return new RosterHistory(roundRosterPairs, rosterMap);
    }

    public static void setActiveRoster(@NonNull State state, @NonNull Roster roster, long round) {
        WritableStates writableStates = state.getWritableStates("RosterService");
        WritableRosterStore writableRosterStore = new WritableRosterStore(writableStates);
        writableRosterStore.putActiveRoster(roster, round);
        ((CommittableWritableStates)writableStates).commit();
    }
}

