/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health;

import com.swirlds.base.formatting.StringFormattingUtils;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class OSHealthCheckUtils {
    private OSHealthCheckUtils() {
    }

    public static <R> SupplierResult<R> timeSupplier(Supplier<R> supplierToMeasure, long timeoutMillis) throws InterruptedException {
        CountDownLatch doneLatch = new CountDownLatch(1);
        AtomicLong start = new AtomicLong();
        AtomicLong end = new AtomicLong();
        AtomicReference result = new AtomicReference();
        Runnable runSupplier = () -> {
            start.set(System.nanoTime());
            result.set(supplierToMeasure.get());
            end.set(System.nanoTime());
            doneLatch.countDown();
        };
        ForkJoinPool.commonPool().execute(runSupplier);
        boolean success = doneLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        if (success) {
            return new SupplierResult(result.get(), Duration.ofNanos(end.get() - start.get()));
        }
        return null;
    }

    public static void reportHeader(StringBuilder sb, String name, boolean passed) {
        sb.append(System.lineSeparator());
        StringFormattingUtils.addLine((StringBuilder)sb, (String)((passed ? "PASSED - " : "FAILED - ") + name));
    }

    public record SupplierResult<R>(R result, Duration duration) {
    }
}

