/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.roster.RosterUtils;

public record SignedStateValidationData(long round, @NonNull Instant consensusTimestamp, @Nullable Hash rosterHash, @NonNull Hash consensusEventsRunningHash) {
    public SignedStateValidationData(@NonNull State that, @Nullable Roster roster) {
        this(PlatformStateUtils.roundOf(that), PlatformStateUtils.consensusTimestampOf(that), roster == null ? null : RosterUtils.hash((Roster)roster), PlatformStateUtils.legacyRunningEventHashOf(that));
    }

    public String getInfoString() {
        return "Round = " + this.round + ", consensus timestamp = " + this.consensusTimestamp + ", consensus Events running hash = " + this.consensusEventsRunningHash + ", roster hash = " + (this.rosterHash != null ? this.rosterHash : "not provided");
    }
}

