/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.node.app.quiescence.QuiescenceController;
import com.hedera.node.app.quiescence.TctProbe;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;

@Singleton
public class QuiescedHeartbeat {
    private static final Logger log = LogManager.getLogger(QuiescedHeartbeat.class);
    private final Platform platform;
    private final QuiescenceController controller;
    private final ScheduledExecutorService scheduler;
    @Nullable
    private ScheduledFuture<?> heartbeatFuture;

    @Inject
    public QuiescedHeartbeat(@NonNull QuiescenceController controller, Platform platform) {
        this(platform, controller, Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "quiesced-heartbeat");
            thread.setDaemon(true);
            return thread;
        }));
    }

    QuiescedHeartbeat(@NonNull Platform platform, @NonNull QuiescenceController controller, @NonNull ScheduledExecutorService scheduler) {
        this.platform = Objects.requireNonNull(platform);
        this.controller = Objects.requireNonNull(controller);
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    public void start(@NonNull Duration heartbeatInterval, @NonNull TctProbe probe) {
        Objects.requireNonNull(heartbeatInterval);
        Objects.requireNonNull(probe);
        this.stop();
        this.heartbeatFuture = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.heartbeat(probe);
            }
            catch (Exception e) {
                log.warn("Unhandled exception in quiesced heartbeat", (Throwable)e);
            }
        }, 0L, heartbeatInterval.toMillis(), TimeUnit.MILLISECONDS);
        log.info("Started quiesced heartbeat at interval {}", (Object)heartbeatInterval);
    }

    public void stop() {
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(false);
            this.heartbeatFuture = null;
        }
    }

    public void shutdown() {
        log.info("Shutting down quiescence heartbeat");
        this.stop();
        this.scheduler.shutdown();
    }

    private void heartbeat(@NonNull TctProbe probe) {
        try {
            QuiescenceCommand commandNow;
            Instant tct = probe.findTct();
            if (tct != null) {
                this.controller.setNextTargetConsensusTime(tct);
            }
            if ((commandNow = this.controller.getQuiescenceStatus()) != QuiescenceCommand.QUIESCE) {
                log.info("Stopping quiescence heartbeat ({})", (Object)commandNow);
                this.platform.quiescenceCommand(commandNow);
                this.stop();
            }
        }
        catch (Exception e) {
            this.platform.quiescenceCommand(QuiescenceCommand.DONT_QUIESCE);
            this.stop();
            throw e;
        }
    }
}

