/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats.v6;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SignatureFile;
import com.hedera.hapi.streams.SignatureObject;
import com.hedera.hapi.streams.SignatureType;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.HashingOutputStream;
import org.hiero.base.crypto.Signer;
import org.hiero.base.io.streams.SerializableDataOutputStream;

final class SignatureWriterV6 {
    private static final Logger logger = LogManager.getLogger(SignatureWriterV6.class);
    private static final String RECORD_SIG_EXTENSION_SUFFIX = "_sig";

    private SignatureWriterV6() {
    }

    static void writeSignatureFile(@NonNull Path recordFilePath, @NonNull Bytes recordFileHash, @NonNull Signer signer, boolean writeMetadataSignature, int recordFileVersion, SemanticVersion hapiProtoVersion, long blockNumber, @NonNull Bytes startRunningHash, @NonNull Bytes endRunningHash) {
        Path sigFilePath = SignatureWriterV6.getSigFilePath(recordFilePath);
        try (OutputStream fileOut = Files.newOutputStream(sigFilePath, StandardOpenOption.CREATE_NEW);){
            WritableStreamingData streamingData = new WritableStreamingData(fileOut);
            Bytes metadataHash = null;
            if (writeMetadataSignature) {
                HashingOutputStream hashingOutputStream = new HashingOutputStream(MessageDigest.getInstance(DigestType.SHA_384.algorithmName()));
                SerializableDataOutputStream dataOutputStream = new SerializableDataOutputStream((OutputStream)hashingOutputStream);
                dataOutputStream.writeInt(recordFileVersion);
                dataOutputStream.writeInt(hapiProtoVersion.major());
                dataOutputStream.writeInt(hapiProtoVersion.minor());
                dataOutputStream.writeInt(hapiProtoVersion.patch());
                startRunningHash.writeTo((OutputStream)dataOutputStream);
                endRunningHash.writeTo((OutputStream)dataOutputStream);
                dataOutputStream.writeLong(blockNumber);
                dataOutputStream.close();
                metadataHash = Bytes.wrap((byte[])hashingOutputStream.getDigest());
            }
            SignatureFile signatureFile = new SignatureFile(SignatureWriterV6.generateSignatureObject(signer, recordFileHash), writeMetadataSignature ? SignatureWriterV6.generateSignatureObject(signer, metadataHash) : null);
            streamingData.writeByte((byte)6);
            SignatureFile.PROTOBUF.write((Object)signatureFile, (WritableSequentialData)streamingData);
            logger.debug("signature file saved: {}", (Object)sigFilePath);
            fileOut.flush();
        }
        catch (FileAlreadyExistsException ignore) {
            logger.info("Skipping signature file for {} as it already exists", (Object)recordFilePath);
        }
        catch (IOException e) {
            logger.error("Fail to generate signature file for {}", (Object)recordFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static SignatureObject generateSignatureObject(@NonNull Signer signer, @NonNull Bytes hash) {
        Bytes signature = signer.sign(hash.toByteArray()).getBytes();
        return SignatureObject.newBuilder().type(SignatureType.SHA_384_WITH_RSA).length((int)signature.length()).checksum(101 - (int)signature.length()).signature(signature).hashObject(new HashObject(HashAlgorithm.SHA_384, (int)hash.length(), hash)).build();
    }

    private static Path getSigFilePath(@NonNull Path recordFilePath) {
        String recordFileName = recordFilePath.getFileName().toString();
        if (recordFileName.endsWith(".gz")) {
            recordFileName = recordFileName.substring(0, recordFileName.length() - ".gz".length());
        }
        return recordFilePath.resolveSibling(recordFileName + RECORD_SIG_EXTENSION_SUFFIX);
    }
}

