/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.validation;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hapi.utils.InvalidTransactionException;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.AutoRenewConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class ExpiryValidatorImpl
implements ExpiryValidator {
    private final HandleContext context;

    public ExpiryValidatorImpl(@NonNull HandleContext context) {
        this.context = Objects.requireNonNull(context, "context must not be null");
    }

    @NonNull
    public ExpiryMeta resolveCreationAttempt(boolean entityCanSelfFundRenewal, @NonNull ExpiryMeta creationMeta, @NonNull HederaFunctionality functionality) {
        if (creationMeta.hasAutoRenewAccountId()) {
            this.validateAutoRenewAccount(Objects.requireNonNull(creationMeta.autoRenewAccountId()));
        }
        long effectiveExpiry = creationMeta.expiry();
        if (this.hasCompleteAutoRenewSpec(entityCanSelfFundRenewal, creationMeta)) {
            effectiveExpiry = ExpiryValidatorImpl.clampedAdd(this.context.consensusNow().getEpochSecond(), creationMeta.autoRenewPeriod());
        }
        if (functionality == HederaFunctionality.CONSENSUS_CREATE_TOPIC) {
            this.context.attributeValidator().validateExpiry(effectiveExpiry);
            this.validateAutoRenew(creationMeta);
        } else if (functionality == HederaFunctionality.TOKEN_CREATE) {
            try {
                this.validateAutoRenew(creationMeta);
            }
            catch (HandleException e) {
                if (e.getStatus() == com.hedera.hapi.node.base.ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE) {
                    throw new HandleException(com.hedera.hapi.node.base.ResponseCodeEnum.INVALID_RENEWAL_PERIOD);
                }
                throw e;
            }
            this.context.attributeValidator().validateExpiry(effectiveExpiry);
        } else {
            this.validateAutoRenew(creationMeta);
            this.context.attributeValidator().validateExpiry(effectiveExpiry);
        }
        return new ExpiryMeta(effectiveExpiry, creationMeta.autoRenewPeriod(), creationMeta.autoRenewAccountId());
    }

    private void validateAutoRenew(ExpiryMeta creationMeta) {
        if (creationMeta.hasAutoRenewPeriod()) {
            this.context.attributeValidator().validateAutoRenewPeriod(creationMeta.autoRenewPeriod());
        }
    }

    @NonNull
    public ExpiryMeta resolveUpdateAttempt(@NonNull ExpiryMeta currentMeta, @NonNull ExpiryMeta updateMeta) {
        if (updateMeta.hasAutoRenewAccountId()) {
            this.validateAutoRenewAccount(updateMeta.autoRenewAccountId());
        }
        long resolvedExpiry = currentMeta.expiry();
        if (updateMeta.hasExplicitExpiry()) {
            this.context.attributeValidator().validateExpiry(updateMeta.expiry());
            HandleException.validateFalse((updateMeta.expiry() < currentMeta.expiry() ? 1 : 0) != 0, (com.hedera.hapi.node.base.ResponseCodeEnum)com.hedera.hapi.node.base.ResponseCodeEnum.EXPIRATION_REDUCTION_NOT_ALLOWED);
            resolvedExpiry = updateMeta.expiry();
        }
        long resolvedAutoRenewPeriod = currentMeta.autoRenewPeriod();
        if (updateMeta.hasAutoRenewPeriod()) {
            this.context.attributeValidator().validateAutoRenewPeriod(updateMeta.autoRenewPeriod());
            resolvedAutoRenewPeriod = updateMeta.autoRenewPeriod();
        }
        AccountID resolvedAutoRenewAccountId = currentMeta.autoRenewAccountId();
        if (updateMeta.hasAutoRenewAccountId()) {
            if (!currentMeta.hasAutoRenewAccountId()) {
                this.context.attributeValidator().validateAutoRenewPeriod(resolvedAutoRenewPeriod);
            }
            resolvedAutoRenewAccountId = updateMeta.autoRenewAccountId();
        }
        return new ExpiryMeta(resolvedExpiry, resolvedAutoRenewPeriod, resolvedAutoRenewAccountId);
    }

    @NonNull
    public com.hedera.hapi.node.base.ResponseCodeEnum expirationStatus(@NonNull EntityType entityType, boolean isMarkedExpired, long balanceAvailableForSelfRenewal) {
        boolean isSmartContract = entityType.equals((Object)EntityType.CONTRACT_BYTECODE);
        AutoRenewConfig autoRenewConfig = (AutoRenewConfig)this.context.configuration().getConfigData(AutoRenewConfig.class);
        if (!autoRenewConfig.isAutoRenewEnabled() || balanceAvailableForSelfRenewal > 0L || !isMarkedExpired || this.isExpiryDisabled(isSmartContract, autoRenewConfig.expireAccounts(), autoRenewConfig.expireContracts())) {
            return com.hedera.hapi.node.base.ResponseCodeEnum.OK;
        }
        return isSmartContract ? com.hedera.hapi.node.base.ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL : com.hedera.hapi.node.base.ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL;
    }

    private boolean hasCompleteAutoRenewSpec(boolean entityCanSelfFundRenewal, ExpiryMeta creationMetadata) {
        return creationMetadata.hasFullAutoRenewSpec() || !creationMetadata.hasExplicitExpiry() && entityCanSelfFundRenewal;
    }

    private void validateAutoRenewAccount(AccountID accountID) {
        HederaConfig hederaConfig = (HederaConfig)this.context.configuration().getConfigData(HederaConfig.class);
        if (this.isSentinelAccount(accountID)) {
            return;
        }
        HandleException.validateTrue((accountID.shardNum() == hederaConfig.shard() && accountID.realmNum() == hederaConfig.realm() ? 1 : 0) != 0, (com.hedera.hapi.node.base.ResponseCodeEnum)com.hedera.hapi.node.base.ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        ReadableAccountStore accountStore = (ReadableAccountStore)this.context.storeFactory().readableStore(ReadableAccountStore.class);
        try {
            Account account = accountStore.getAccountById(accountID);
            if (account == null || account.deleted()) {
                throw new HandleException(com.hedera.hapi.node.base.ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
            }
        }
        catch (InvalidTransactionException e) {
            throw new HandleException(CommonPbjConverters.toPbj((ResponseCodeEnum)e.getResponseCode()));
        }
    }

    private boolean isExpiryDisabled(boolean smartContract, boolean expireAccounts, boolean expireContracts) {
        return smartContract && !expireContracts || !smartContract && !expireAccounts;
    }

    private static long clampedAdd(long a, long b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException ae) {
            return a > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    private boolean isSentinelAccount(@NonNull AccountID accountID) {
        return accountID.hasAccountNum() && accountID.shardNum() == 0L && accountID.realmNum() == 0L && accountID.accountNum() == 0L;
    }
}

