/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.swirlds.demo.consistency.ConsistencyTestingToolState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hiero.base.utility.ByteUtils;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.transaction.Transaction;

public record ConsistencyTestingToolRound(long roundNumber, long currentState, @NonNull List<Long> transactionsContents) implements Comparable<ConsistencyTestingToolRound>
{
    private static final String ROUND_NUMBER_STRING = "Round Number: ";
    private static final String CURRENT_STATE_STRING = "Current State: ";
    private static final String TRANSACTIONS_STRING = "Transactions: ";
    private static final String FIELD_SEPARATOR = "; ";
    private static final String LIST_ELEMENT_SEPARATOR = ", ";

    @NonNull
    public static ConsistencyTestingToolRound fromRound(@NonNull Round round, long currentState) {
        Objects.requireNonNull(round);
        ArrayList<Long> transactionContents = new ArrayList<Long>();
        round.forEachTransaction(transaction -> {
            if (ConsistencyTestingToolState.isSystemTransaction((Transaction)transaction)) {
                return;
            }
            transactionContents.add(ByteUtils.byteArrayToLong((byte[])transaction.getApplicationTransaction().toByteArray(), (int)0));
        });
        return new ConsistencyTestingToolRound(round.getRoundNum(), currentState, transactionContents);
    }

    @Nullable
    public static ConsistencyTestingToolRound fromString(@NonNull String roundString) {
        Objects.requireNonNull(roundString);
        try {
            List<String> fields = Arrays.stream(roundString.split(FIELD_SEPARATOR)).toList();
            String field = fields.get(0);
            long roundNumber = Long.parseLong(field.substring(ROUND_NUMBER_STRING.length()));
            field = fields.get(1);
            long currentState = Long.parseLong(field.substring(CURRENT_STATE_STRING.length()));
            field = fields.get(2);
            String transactionsString = field.substring(field.indexOf("[") + 1, field.indexOf("]"));
            List<Long> transactionsContents = Arrays.stream(transactionsString.split(LIST_ELEMENT_SEPARATOR)).filter(s -> !s.isEmpty()).map(Long::parseLong).toList();
            return new ConsistencyTestingToolRound(roundNumber, currentState, transactionsContents);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int compareTo(@NonNull ConsistencyTestingToolRound other) {
        Objects.requireNonNull(other);
        return Long.compare(this.roundNumber, other.roundNumber);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof ConsistencyTestingToolRound) {
            ConsistencyTestingToolRound otherRound = (ConsistencyTestingToolRound)other;
            return this.roundNumber == otherRound.roundNumber && this.currentState == otherRound.currentState && this.transactionsContents.equals(otherRound.transactionsContents);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.roundNumber, this.currentState, this.transactionsContents);
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ROUND_NUMBER_STRING);
        builder.append(this.roundNumber);
        builder.append(FIELD_SEPARATOR);
        builder.append(CURRENT_STATE_STRING);
        builder.append(this.currentState);
        builder.append(FIELD_SEPARATOR);
        builder.append(TRANSACTIONS_STRING);
        builder.append("[");
        for (int index = 0; index < this.transactionsContents.size(); ++index) {
            builder.append(this.transactionsContents.get(index));
            if (index == this.transactionsContents.size() - 1) continue;
            builder.append(LIST_ELEMENT_SEPARATOR);
        }
        builder.append("]\n");
        return builder.toString();
    }
}

