/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.swirlds.common.io.IOIterator;
import com.swirlds.common.io.extendable.ExtendableInputStream;
import com.swirlds.common.io.extendable.InputStreamExtension;
import com.swirlds.common.io.extendable.extensions.CountingStreamExtension;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;

public class ObjectStreamIterator<T extends SelfSerializable>
implements IOIterator<T> {
    private final SerializableDataInputStream in;
    private final CountingStreamExtension byteCounter = new CountingStreamExtension();
    private Exception exception;
    private T next;
    private final boolean toleratePartialFile;
    private static final int EXPECTED_OBJECT_STREAM_VERSION = 1;
    private static final int EXPECTED_EVENT_STREAM_VERSION = 5;

    public ObjectStreamIterator(Path objectStreamFile, boolean toleratePartialFile) throws IOException {
        this(new BufferedInputStream(new FileInputStream(objectStreamFile.toFile())), toleratePartialFile);
    }

    public ObjectStreamIterator(InputStream in, boolean toleratePartialFile) throws IOException {
        this.in = new SerializableDataInputStream((InputStream)new ExtendableInputStream(in, (InputStreamExtension)this.byteCounter));
        this.toleratePartialFile = toleratePartialFile;
        try {
            int eventStreamVersion = this.in.readInt();
            if (eventStreamVersion != 5) {
                throw new IOException("unexpected event stream version " + eventStreamVersion);
            }
            int objectStreamVersion = this.in.readInt();
            if (objectStreamVersion != 1) {
                throw new IOException("unexpected object stream version " + objectStreamVersion);
            }
        }
        catch (EOFException e) {
            if (!toleratePartialFile) {
                this.exception = e;
                throw e;
            }
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    public boolean hasNext() throws IOException {
        if (this.exception != null) {
            throw new IOException(this.exception);
        }
        if (this.next == null) {
            long initialCount = this.byteCounter.getCount();
            try {
                this.next = this.in.readSerializable();
            }
            catch (EOFException e) {
                if (this.byteCounter.getCount() > initialCount && !this.toleratePartialFile) {
                    this.exception = e;
                    throw e;
                }
                return false;
            }
            catch (IOException e) {
                this.exception = e;
                throw e;
            }
        }
        return this.next != null;
    }

    public T next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.next;
            return t;
        }
        finally {
            this.next = null;
        }
    }

    public T peek() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    public long getBytesRead() {
        return this.byteCounter.getCount();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

