/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.hasher;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hasher.StateHasherMetrics;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultStateHasher
implements StateHasher {
    private static final Logger logger = LogManager.getLogger(DefaultStateHasher.class);
    private final MerkleCryptography merkleCryptography;
    private final StateHasherMetrics metrics;

    public DefaultStateHasher(@NonNull PlatformContext platformContext) {
        this.merkleCryptography = platformContext.getMerkleCryptography();
        this.metrics = new StateHasherMetrics(platformContext.getMetrics());
    }

    @Override
    @Nullable
    public ReservedSignedState hashState(@NonNull StateWithHashComplexity stateWithHashComplexity) {
        ReservedSignedState reservedSignedState = stateWithHashComplexity.reservedSignedState();
        Instant start = Instant.now();
        try {
            this.merkleCryptography.digestTreeAsync(reservedSignedState.get().getState().getRoot()).get();
            this.metrics.reportHashingTime(Duration.between(start, Instant.now()));
            return reservedSignedState;
        }
        catch (ExecutionException e) {
            logger.fatal(LogMarker.EXCEPTION.getMarker(), "Exception occurred during SignedState hashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while hashing state. Expect buggy behavior.");
            Thread.currentThread().interrupt();
        }
        return null;
    }
}

