/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.stream;

import com.swirlds.common.stream.EventStreamType;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.stream.internal.TimestampStreamFileWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signer;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public final class StreamUtils {
    public static void writeRoundsToStream(Path dir, Signer signer, Duration eventStreamWindowSize, Collection<ConsensusRound> rounds) {
        RunningHashCalculatorForStream stream = new RunningHashCalculatorForStream((LinkedObjectStream)new TimestampStreamFileWriter(dir.toAbsolutePath().toString(), eventStreamWindowSize.toMillis(), signer, false, (StreamType)EventStreamType.getInstance()));
        stream.setRunningHash(new Hash(new byte[DigestType.SHA_384.digestLength()]));
        rounds.stream().flatMap(r -> r.getStreamedEvents().stream()).forEach(arg_0 -> ((LinkedObjectStream)stream).addObject(arg_0));
        stream.close();
    }
}

