/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.hints;

import com.hedera.common.nativesupport.SingletonLoader;
import com.hedera.cryptography.hints.AggregationAndVerificationKeys;

public class HintsLibraryBridge {
    private static final SingletonLoader<HintsLibraryBridge> INSTANCE_HOLDER = new SingletonLoader("hints", (Object)new HintsLibraryBridge());
    private static final short MAX_SIGNERS_NUM = 1023;
    private static final long MAX_SUM_OF_WEIGHTS = Long.MAX_VALUE;

    private HintsLibraryBridge() {
    }

    public static HintsLibraryBridge getInstance() {
        return (HintsLibraryBridge)INSTANCE_HOLDER.getInstance();
    }

    public byte[] initCRS(short signersNum) {
        if (signersNum < 1 || signersNum > 1023) {
            return null;
        }
        return this.initCRSImpl(signersNum);
    }

    private native byte[] initCRSImpl(short var1);

    public native byte[] updateCRS(byte[] var1, byte[] var2);

    public native boolean verifyCRS(byte[] var1, byte[] var2, byte[] var3);

    public byte[] pruneCRS(byte[] prevCRS, short signersNum) {
        if (prevCRS == null || signersNum < 1 || signersNum > 1023) {
            return null;
        }
        return this.pruneCRSImpl(prevCRS, signersNum);
    }

    private native byte[] pruneCRSImpl(byte[] var1, short var2);

    public native byte[] generateSecretKey(byte[] var1);

    public byte[] computeHints(byte[] crs, byte[] secretKey, int partyId, int n) {
        if (!HintsLibraryBridge.validateCRS(crs, n) || !HintsLibraryBridge.validatePartyId(partyId, n) || secretKey == null) {
            return null;
        }
        return this.computeHintsImpl(crs, secretKey, partyId, n);
    }

    private native byte[] computeHintsImpl(byte[] var1, byte[] var2, int var3, int var4);

    public boolean validateHintsKey(byte[] crs, byte[] hintsPublicKey, int partyId, int n) {
        if (!HintsLibraryBridge.validateCRS(crs, n) || !HintsLibraryBridge.validatePartyId(partyId, n) || hintsPublicKey == null) {
            return false;
        }
        return this.validateHintsKeyImpl(crs, hintsPublicKey, partyId, n);
    }

    private native boolean validateHintsKeyImpl(byte[] var1, byte[] var2, int var3, int var4);

    public AggregationAndVerificationKeys preprocess(byte[] crs, int[] parties, byte[][] hintsPublicKeys, long[] weights, int n) {
        if (!HintsLibraryBridge.validateCRS(crs, n) || parties == null || hintsPublicKeys == null || weights == null || !HintsLibraryBridge.validateWeightsSum(weights)) {
            return null;
        }
        if (parties.length >= n || hintsPublicKeys.length != parties.length || weights.length != parties.length) {
            return null;
        }
        for (int i = 0; i < parties.length; ++i) {
            if (!HintsLibraryBridge.validatePartyId(parties[i], n)) {
                return null;
            }
            if (hintsPublicKeys[i] != null && weights[i] >= 0L) continue;
            return null;
        }
        return this.preprocessImpl(crs, parties, hintsPublicKeys, weights, n);
    }

    private native AggregationAndVerificationKeys preprocessImpl(byte[] var1, int[] var2, byte[][] var3, long[] var4, int var5);

    public byte[] signBls(byte[] message, byte[] privateKey) {
        if (message == null || message.length == 0 || privateKey == null || privateKey.length == 0) {
            return null;
        }
        return this.signBlsImpl(message, privateKey);
    }

    private native byte[] signBlsImpl(byte[] var1, byte[] var2);

    public boolean verifyBls(byte[] signature, byte[] message, byte[] aggregationKey, int partyId) {
        if (signature == null || signature.length == 0 || message == null || message.length == 0 || aggregationKey == null || aggregationKey.length == 0 || partyId >= 1023) {
            return false;
        }
        return this.verifyBlsImpl(signature, message, aggregationKey, partyId);
    }

    private native boolean verifyBlsImpl(byte[] var1, byte[] var2, byte[] var3, int var4);

    public boolean verifyBlsBatch(byte[] message, byte[] aggregationKey, int[] parties, byte[][] partialSignatures) {
        if (message == null || message.length == 0 || aggregationKey == null || aggregationKey.length == 0 || parties == null || parties.length == 0 || partialSignatures == null || partialSignatures.length == 0 || parties.length != partialSignatures.length) {
            return false;
        }
        for (int i = 0; i < parties.length; ++i) {
            if (parties[i] < 1023) continue;
            return false;
        }
        return this.verifyBlsBatchImpl(message, aggregationKey, parties, partialSignatures);
    }

    private native boolean verifyBlsBatchImpl(byte[] var1, byte[] var2, int[] var3, byte[][] var4);

    public byte[] aggregateSignatures(byte[] crs, byte[] aggregationKey, byte[] verificationKey, int[] parties, byte[][] partialSignatures) {
        if (crs == null || crs.length == 0 || aggregationKey == null || aggregationKey.length == 0 || verificationKey == null || verificationKey.length == 0 || parties == null || parties.length == 0 || partialSignatures == null || partialSignatures.length == 0 || parties.length != partialSignatures.length) {
            return null;
        }
        for (int i = 0; i < parties.length; ++i) {
            if (parties[i] < 1023) continue;
            return null;
        }
        return this.aggregateSignaturesImpl(crs, aggregationKey, verificationKey, parties, partialSignatures);
    }

    private native byte[] aggregateSignaturesImpl(byte[] var1, byte[] var2, byte[] var3, int[] var4, byte[][] var5);

    public boolean verifyAggregate(byte[] signature, byte[] message, byte[] verificationKey, long thresholdNumerator, long thresholdDenominator) {
        if (signature == null || signature.length == 0 || message == null || message.length == 0 || verificationKey == null || verificationKey.length == 0 || thresholdNumerator <= 0L || thresholdDenominator <= 0L) {
            return false;
        }
        return this.verifyAggregateImpl(signature, message, verificationKey, thresholdNumerator, thresholdDenominator);
    }

    private native boolean verifyAggregateImpl(byte[] var1, byte[] var2, byte[] var3, long var4, long var6);

    private static boolean validateCRS(byte[] crs, int n) {
        return n > 0 && (n & n - 1) == 0 && crs != null && crs.length >= 304 + n * 288;
    }

    private static int inferNFromCRSLength(byte[] crs) {
        if (crs == null) {
            return -1;
        }
        return (crs.length - 304) / 288;
    }

    private static boolean validatePartyId(int partyId, int n) {
        return n <= 1023 && partyId >= 0 && partyId < n;
    }

    public static boolean validateWeightsSum(long[] weights) {
        try {
            long sum = 0L;
            for (int i = 0; i < weights.length; ++i) {
                sum = Math.addExact(sum, weights[i]);
            }
            return sum >= 0L && sum <= Long.MAX_VALUE;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    static {
        HintsLibraryBridge.class.getModule().addOpens(INSTANCE_HOLDER.getNativeLibraryPackageName(), SingletonLoader.class.getModule());
    }
}

