/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.codec.NftTransferJsonCodec;
import com.hedera.hapi.node.base.codec.NftTransferProtoCodec;
import com.hedera.hapi.node.base.schema.NftTransferSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class NftTransfer {
    public static final Codec<NftTransfer> PROTOBUF = new NftTransferProtoCodec();
    public static final JsonCodec<NftTransfer> JSON = new NftTransferJsonCodec();
    public static final NftTransfer DEFAULT = NftTransfer.newBuilder().build();
    @Nullable
    private final AccountID senderAccountID;
    @Nullable
    private final AccountID receiverAccountID;
    private final long serialNumber;
    private final boolean isApproval;
    private final OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall;
    private final OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public NftTransfer(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall, OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall) {
        this.$unknownFields = null;
        this.senderAccountID = senderAccountID;
        this.receiverAccountID = receiverAccountID;
        this.serialNumber = serialNumber;
        this.isApproval = isApproval;
        if (senderAllowanceHookCall == null) {
            throw new NullPointerException("Parameter 'senderAllowanceHookCall' must be supplied and can not be null");
        }
        this.senderAllowanceHookCall = senderAllowanceHookCall;
        if (receiverAllowanceHookCall == null) {
            throw new NullPointerException("Parameter 'receiverAllowanceHookCall' must be supplied and can not be null");
        }
        this.receiverAllowanceHookCall = receiverAllowanceHookCall;
    }

    public NftTransfer(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall, OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.senderAccountID = senderAccountID;
        this.receiverAccountID = receiverAccountID;
        this.serialNumber = serialNumber;
        this.isApproval = isApproval;
        if (senderAllowanceHookCall == null) {
            throw new NullPointerException("Parameter 'senderAllowanceHookCall' must be supplied and can not be null");
        }
        this.senderAllowanceHookCall = senderAllowanceHookCall;
        if (receiverAllowanceHookCall == null) {
            throw new NullPointerException("Parameter 'receiverAllowanceHookCall' must be supplied and can not be null");
        }
        this.receiverAllowanceHookCall = receiverAllowanceHookCall;
    }

    public AccountID senderAccountID() {
        return this.senderAccountID;
    }

    public AccountID receiverAccountID() {
        return this.receiverAccountID;
    }

    public long serialNumber() {
        return this.serialNumber;
    }

    public boolean isApproval() {
        return this.isApproval;
    }

    public OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall() {
        return this.senderAllowanceHookCall;
    }

    public OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall() {
        return this.receiverAllowanceHookCall;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)this.senderAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)this.receiverAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)this.serialNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)this.isApproval, (boolean)true);
            if (this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_TX_SENDER_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.PRE_TX_SENDER_ALLOWANCE_HOOK, (Object)((HookCall)this.senderAllowanceHookCall.as()), HookCall.PROTOBUF);
            }
            if (this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_POST_TX_SENDER_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.PRE_POST_TX_SENDER_ALLOWANCE_HOOK, (Object)((HookCall)this.senderAllowanceHookCall.as()), HookCall.PROTOBUF);
            }
            if (this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_TX_RECEIVER_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.PRE_TX_RECEIVER_ALLOWANCE_HOOK, (Object)((HookCall)this.receiverAllowanceHookCall.as()), HookCall.PROTOBUF);
            }
            if (this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK, (Object)((HookCall)this.receiverAllowanceHookCall.as()), HookCall.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.senderAccountID != null && !this.senderAccountID.equals(NftTransfer.DEFAULT.senderAccountID)) {
                result = 31 * result + this.senderAccountID.hashCode();
            }
            if (this.receiverAccountID != null && !this.receiverAccountID.equals(NftTransfer.DEFAULT.receiverAccountID)) {
                result = 31 * result + this.receiverAccountID.hashCode();
            }
            if (this.serialNumber != NftTransfer.DEFAULT.serialNumber) {
                result = 31 * result + Long.hashCode(this.serialNumber);
            }
            if (this.isApproval != NftTransfer.DEFAULT.isApproval) {
                result = 31 * result + Boolean.hashCode(this.isApproval);
            }
            if (this.senderAllowanceHookCall != null && !this.senderAllowanceHookCall.equals(NftTransfer.DEFAULT.senderAllowanceHookCall)) {
                result = 31 * result + this.senderAllowanceHookCall.hashCode();
            }
            if (this.receiverAllowanceHookCall != null && !this.receiverAllowanceHookCall.equals(NftTransfer.DEFAULT.receiverAllowanceHookCall)) {
                result = 31 * result + this.receiverAllowanceHookCall.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NftTransfer thatObj = (NftTransfer)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.senderAccountID == null && thatObj.senderAccountID != null) {
            return false;
        }
        if (this.senderAccountID != null && !this.senderAccountID.equals(thatObj.senderAccountID)) {
            return false;
        }
        if (this.receiverAccountID == null && thatObj.receiverAccountID != null) {
            return false;
        }
        if (this.receiverAccountID != null && !this.receiverAccountID.equals(thatObj.receiverAccountID)) {
            return false;
        }
        if (this.serialNumber != thatObj.serialNumber) {
            return false;
        }
        if (this.isApproval != thatObj.isApproval) {
            return false;
        }
        if (this.senderAllowanceHookCall == null && thatObj.senderAllowanceHookCall != null) {
            return false;
        }
        if (this.senderAllowanceHookCall != null && !this.senderAllowanceHookCall.equals(thatObj.senderAllowanceHookCall)) {
            return false;
        }
        if (this.receiverAllowanceHookCall == null && thatObj.receiverAllowanceHookCall != null) {
            return false;
        }
        if (this.receiverAllowanceHookCall != null && !this.receiverAllowanceHookCall.equals(thatObj.receiverAllowanceHookCall)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "NftTransfer[senderAccountID=" + String.valueOf(this.senderAccountID) + ", receiverAccountID=" + String.valueOf(this.receiverAccountID) + ", serialNumber=" + this.serialNumber + ", isApproval=" + this.isApproval + ", senderAllowanceHookCall=" + String.valueOf(this.senderAllowanceHookCall) + ", receiverAllowanceHookCall=" + String.valueOf(this.receiverAllowanceHookCall) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasSenderAccountID() {
        return this.senderAccountID != null;
    }

    public AccountID senderAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderAccountID() ? this.senderAccountID : defaultValue;
    }

    @NonNull
    public AccountID senderAccountIDOrThrow() {
        return Objects.requireNonNull(this.senderAccountID, "Field senderAccountID is null");
    }

    public void ifSenderAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderAccountID()) {
            ifPresent.accept(this.senderAccountID);
        }
    }

    public boolean hasReceiverAccountID() {
        return this.receiverAccountID != null;
    }

    public AccountID receiverAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasReceiverAccountID() ? this.receiverAccountID : defaultValue;
    }

    @NonNull
    public AccountID receiverAccountIDOrThrow() {
        return Objects.requireNonNull(this.receiverAccountID, "Field receiverAccountID is null");
    }

    public void ifReceiverAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasReceiverAccountID()) {
            ifPresent.accept(this.receiverAccountID);
        }
    }

    @Nullable
    public HookCall preTxSenderAllowanceHook() {
        return this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_TX_SENDER_ALLOWANCE_HOOK ? (HookCall)this.senderAllowanceHookCall.value() : null;
    }

    public boolean hasPreTxSenderAllowanceHook() {
        return this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_TX_SENDER_ALLOWANCE_HOOK;
    }

    public HookCall preTxSenderAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPreTxSenderAllowanceHook() ? this.preTxSenderAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall preTxSenderAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.preTxSenderAllowanceHook(), "Field preTxSenderAllowanceHook is null");
    }

    @Nullable
    public HookCall prePostTxSenderAllowanceHook() {
        return this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_POST_TX_SENDER_ALLOWANCE_HOOK ? (HookCall)this.senderAllowanceHookCall.value() : null;
    }

    public boolean hasPrePostTxSenderAllowanceHook() {
        return this.senderAllowanceHookCall.kind() == SenderAllowanceHookCallOneOfType.PRE_POST_TX_SENDER_ALLOWANCE_HOOK;
    }

    public HookCall prePostTxSenderAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPrePostTxSenderAllowanceHook() ? this.prePostTxSenderAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall prePostTxSenderAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.prePostTxSenderAllowanceHook(), "Field prePostTxSenderAllowanceHook is null");
    }

    @Nullable
    public HookCall preTxReceiverAllowanceHook() {
        return this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_TX_RECEIVER_ALLOWANCE_HOOK ? (HookCall)this.receiverAllowanceHookCall.value() : null;
    }

    public boolean hasPreTxReceiverAllowanceHook() {
        return this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_TX_RECEIVER_ALLOWANCE_HOOK;
    }

    public HookCall preTxReceiverAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPreTxReceiverAllowanceHook() ? this.preTxReceiverAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall preTxReceiverAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.preTxReceiverAllowanceHook(), "Field preTxReceiverAllowanceHook is null");
    }

    @Nullable
    public HookCall prePostTxReceiverAllowanceHook() {
        return this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK ? (HookCall)this.receiverAllowanceHookCall.value() : null;
    }

    public boolean hasPrePostTxReceiverAllowanceHook() {
        return this.receiverAllowanceHookCall.kind() == ReceiverAllowanceHookCallOneOfType.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK;
    }

    public HookCall prePostTxReceiverAllowanceHookOrElse(@NonNull HookCall defaultValue) {
        return this.hasPrePostTxReceiverAllowanceHook() ? this.prePostTxReceiverAllowanceHook() : defaultValue;
    }

    @NonNull
    public HookCall prePostTxReceiverAllowanceHookOrThrow() {
        return Objects.requireNonNull(this.prePostTxReceiverAllowanceHook(), "Field prePostTxReceiverAllowanceHook is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval, this.senderAllowanceHookCall, this.receiverAllowanceHookCall, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum SenderAllowanceHookCallOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        PRE_TX_SENDER_ALLOWANCE_HOOK(5, "pre_tx_sender_allowance_hook"),
        PRE_POST_TX_SENDER_ALLOWANCE_HOOK(6, "pre_post_tx_sender_allowance_hook");

        private final int protoOrdinal;
        private final String protoName;

        private SenderAllowanceHookCallOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static SenderAllowanceHookCallOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 5 -> PRE_TX_SENDER_ALLOWANCE_HOOK;
                case 6 -> PRE_POST_TX_SENDER_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static SenderAllowanceHookCallOneOfType fromString(String name) {
            return switch (name) {
                case "pre_tx_sender_allowance_hook", "PRE_TX_SENDER_ALLOWANCE_HOOK" -> PRE_TX_SENDER_ALLOWANCE_HOOK;
                case "pre_post_tx_sender_allowance_hook", "PRE_POST_TX_SENDER_ALLOWANCE_HOOK" -> PRE_POST_TX_SENDER_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum ReceiverAllowanceHookCallOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        PRE_TX_RECEIVER_ALLOWANCE_HOOK(7, "pre_tx_receiver_allowance_hook"),
        PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK(8, "pre_post_tx_receiver_allowance_hook");

        private final int protoOrdinal;
        private final String protoName;

        private ReceiverAllowanceHookCallOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ReceiverAllowanceHookCallOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 7 -> PRE_TX_RECEIVER_ALLOWANCE_HOOK;
                case 8 -> PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ReceiverAllowanceHookCallOneOfType fromString(String name) {
            return switch (name) {
                case "pre_tx_receiver_allowance_hook", "PRE_TX_RECEIVER_ALLOWANCE_HOOK" -> PRE_TX_RECEIVER_ALLOWANCE_HOOK;
                case "pre_post_tx_receiver_allowance_hook", "PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK" -> PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private AccountID senderAccountID = null;
        @Nullable
        private AccountID receiverAccountID = null;
        private long serialNumber = 0L;
        private boolean isApproval = false;
        private OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall = NftTransferProtoCodec.SENDER_ALLOWANCE_HOOK_CALL_UNSET;
        private OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall = NftTransferProtoCodec.RECEIVER_ALLOWANCE_HOOK_CALL_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall, OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall) {
            this.$unknownFields = null;
            this.senderAccountID = senderAccountID;
            this.receiverAccountID = receiverAccountID;
            this.serialNumber = serialNumber;
            this.isApproval = isApproval;
            this.senderAllowanceHookCall = senderAllowanceHookCall;
            this.receiverAllowanceHookCall = receiverAllowanceHookCall;
        }

        public Builder(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall, OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.senderAccountID = senderAccountID;
            this.receiverAccountID = receiverAccountID;
            this.serialNumber = serialNumber;
            this.isApproval = isApproval;
            this.senderAllowanceHookCall = senderAllowanceHookCall;
            this.receiverAllowanceHookCall = receiverAllowanceHookCall;
        }

        public NftTransfer build() {
            return new NftTransfer(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval, this.senderAllowanceHookCall, this.receiverAllowanceHookCall);
        }

        public Builder senderAccountID(@Nullable AccountID senderAccountID) {
            this.senderAccountID = senderAccountID;
            return this;
        }

        public Builder senderAccountID(AccountID.Builder builder) {
            this.senderAccountID = builder.build();
            return this;
        }

        public Builder receiverAccountID(@Nullable AccountID receiverAccountID) {
            this.receiverAccountID = receiverAccountID;
            return this;
        }

        public Builder receiverAccountID(AccountID.Builder builder) {
            this.receiverAccountID = builder.build();
            return this;
        }

        public Builder serialNumber(long serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }

        public void clearSenderAllowanceHookCall() {
            this.senderAllowanceHookCall = NftTransferProtoCodec.SENDER_ALLOWANCE_HOOK_CALL_UNSET;
        }

        public Builder preTxSenderAllowanceHook(@Nullable HookCall preTxSenderAllowanceHook) {
            this.senderAllowanceHookCall = new OneOf((Enum)SenderAllowanceHookCallOneOfType.PRE_TX_SENDER_ALLOWANCE_HOOK, (Object)preTxSenderAllowanceHook);
            return this;
        }

        public Builder preTxSenderAllowanceHook(HookCall.Builder builder) {
            this.senderAllowanceHookCall = new OneOf((Enum)SenderAllowanceHookCallOneOfType.PRE_TX_SENDER_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }

        public Builder prePostTxSenderAllowanceHook(@Nullable HookCall prePostTxSenderAllowanceHook) {
            this.senderAllowanceHookCall = new OneOf((Enum)SenderAllowanceHookCallOneOfType.PRE_POST_TX_SENDER_ALLOWANCE_HOOK, (Object)prePostTxSenderAllowanceHook);
            return this;
        }

        public Builder prePostTxSenderAllowanceHook(HookCall.Builder builder) {
            this.senderAllowanceHookCall = new OneOf((Enum)SenderAllowanceHookCallOneOfType.PRE_POST_TX_SENDER_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }

        public void clearReceiverAllowanceHookCall() {
            this.receiverAllowanceHookCall = NftTransferProtoCodec.RECEIVER_ALLOWANCE_HOOK_CALL_UNSET;
        }

        public Builder preTxReceiverAllowanceHook(@Nullable HookCall preTxReceiverAllowanceHook) {
            this.receiverAllowanceHookCall = new OneOf((Enum)ReceiverAllowanceHookCallOneOfType.PRE_TX_RECEIVER_ALLOWANCE_HOOK, (Object)preTxReceiverAllowanceHook);
            return this;
        }

        public Builder preTxReceiverAllowanceHook(HookCall.Builder builder) {
            this.receiverAllowanceHookCall = new OneOf((Enum)ReceiverAllowanceHookCallOneOfType.PRE_TX_RECEIVER_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }

        public Builder prePostTxReceiverAllowanceHook(@Nullable HookCall prePostTxReceiverAllowanceHook) {
            this.receiverAllowanceHookCall = new OneOf((Enum)ReceiverAllowanceHookCallOneOfType.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK, (Object)prePostTxReceiverAllowanceHook);
            return this;
        }

        public Builder prePostTxReceiverAllowanceHook(HookCall.Builder builder) {
            this.receiverAllowanceHookCall = new OneOf((Enum)ReceiverAllowanceHookCallOneOfType.PRE_POST_TX_RECEIVER_ALLOWANCE_HOOK, (Object)builder.build());
            return this;
        }

        public AccountID senderAccountID() {
            return this.senderAccountID;
        }

        public AccountID receiverAccountID() {
            return this.receiverAccountID;
        }

        public long serialNumber() {
            return this.serialNumber;
        }

        public boolean isApproval() {
            return this.isApproval;
        }

        public OneOf<SenderAllowanceHookCallOneOfType> senderAllowanceHookCall() {
            return this.senderAllowanceHookCall;
        }

        public OneOf<ReceiverAllowanceHookCallOneOfType> receiverAllowanceHookCall() {
            return this.receiverAllowanceHookCall;
        }
    }
}

