/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.codec.StakingInfoJsonCodec;
import com.hedera.hapi.node.base.codec.StakingInfoProtoCodec;
import com.hedera.hapi.node.base.schema.StakingInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class StakingInfo {
    public static final Codec<StakingInfo> PROTOBUF = new StakingInfoProtoCodec();
    public static final JsonCodec<StakingInfo> JSON = new StakingInfoJsonCodec();
    public static final StakingInfo DEFAULT = StakingInfo.newBuilder().build();
    private final boolean declineReward;
    @Nullable
    private final Timestamp stakePeriodStart;
    private final long pendingReward;
    private final long stakedToMe;
    private final OneOf<StakedIdOneOfType> stakedId;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public StakingInfo(boolean declineReward, Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId) {
        this.$unknownFields = null;
        this.declineReward = declineReward;
        this.stakePeriodStart = stakePeriodStart;
        this.pendingReward = pendingReward;
        this.stakedToMe = stakedToMe;
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
        this.stakedId = stakedId;
    }

    public StakingInfo(boolean declineReward, Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.declineReward = declineReward;
        this.stakePeriodStart = stakePeriodStart;
        this.pendingReward = pendingReward;
        this.stakedToMe = stakedToMe;
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
        this.stakedId = stakedId;
    }

    public boolean declineReward() {
        return this.declineReward;
    }

    public Timestamp stakePeriodStart() {
        return this.stakePeriodStart;
    }

    public long pendingReward() {
        return this.pendingReward;
    }

    public long stakedToMe() {
        return this.stakedToMe;
    }

    public OneOf<StakedIdOneOfType> stakedId() {
        return this.stakedId;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)StakingInfoSchema.DECLINE_REWARD, (boolean)this.declineReward, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)StakingInfoSchema.STAKE_PERIOD_START, (Object)this.stakePeriodStart, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.PENDING_REWARD, (long)this.pendingReward, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.STAKED_TO_ME, (long)this.stakedToMe, (boolean)true);
            if (this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)StakingInfoSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)this.stakedId.as()), AccountID.PROTOBUF);
            }
            if (this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID) {
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingInfoSchema.STAKED_NODE_ID, (long)((Long)this.stakedId.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.declineReward != StakingInfo.DEFAULT.declineReward) {
                result = 31 * result + Boolean.hashCode(this.declineReward);
            }
            if (this.stakePeriodStart != null && !this.stakePeriodStart.equals(StakingInfo.DEFAULT.stakePeriodStart)) {
                result = 31 * result + this.stakePeriodStart.hashCode();
            }
            if (this.pendingReward != StakingInfo.DEFAULT.pendingReward) {
                result = 31 * result + Long.hashCode(this.pendingReward);
            }
            if (this.stakedToMe != StakingInfo.DEFAULT.stakedToMe) {
                result = 31 * result + Long.hashCode(this.stakedToMe);
            }
            if (this.stakedId != null && !this.stakedId.equals(StakingInfo.DEFAULT.stakedId)) {
                result = 31 * result + this.stakedId.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        StakingInfo thatObj = (StakingInfo)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.declineReward != thatObj.declineReward) {
            return false;
        }
        if (this.stakePeriodStart == null && thatObj.stakePeriodStart != null) {
            return false;
        }
        if (this.stakePeriodStart != null && !this.stakePeriodStart.equals(thatObj.stakePeriodStart)) {
            return false;
        }
        if (this.pendingReward != thatObj.pendingReward) {
            return false;
        }
        if (this.stakedToMe != thatObj.stakedToMe) {
            return false;
        }
        if (this.stakedId == null && thatObj.stakedId != null) {
            return false;
        }
        if (this.stakedId != null && !this.stakedId.equals(thatObj.stakedId)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "StakingInfo[declineReward=" + this.declineReward + ", stakePeriodStart=" + String.valueOf(this.stakePeriodStart) + ", pendingReward=" + this.pendingReward + ", stakedToMe=" + this.stakedToMe + ", stakedId=" + String.valueOf(this.stakedId) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasStakePeriodStart() {
        return this.stakePeriodStart != null;
    }

    public Timestamp stakePeriodStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasStakePeriodStart() ? this.stakePeriodStart : defaultValue;
    }

    @NonNull
    public Timestamp stakePeriodStartOrThrow() {
        return Objects.requireNonNull(this.stakePeriodStart, "Field stakePeriodStart is null");
    }

    public void ifStakePeriodStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasStakePeriodStart()) {
            ifPresent.accept(this.stakePeriodStart);
        }
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.declineReward, this.stakePeriodStart, this.pendingReward, this.stakedToMe, this.stakedId, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(5, "staked_account_id"),
        STAKED_NODE_ID(6, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 5 -> STAKED_ACCOUNT_ID;
                case 6 -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "staked_account_id", "STAKED_ACCOUNT_ID" -> STAKED_ACCOUNT_ID;
                case "staked_node_id", "STAKED_NODE_ID" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private boolean declineReward = false;
        @Nullable
        private Timestamp stakePeriodStart = null;
        private long pendingReward = 0L;
        private long stakedToMe = 0L;
        private OneOf<StakedIdOneOfType> stakedId = StakingInfoProtoCodec.STAKED_ID_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(boolean declineReward, Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId) {
            this.$unknownFields = null;
            this.declineReward = declineReward;
            this.stakePeriodStart = stakePeriodStart;
            this.pendingReward = pendingReward;
            this.stakedToMe = stakedToMe;
            this.stakedId = stakedId;
        }

        public Builder(boolean declineReward, Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.declineReward = declineReward;
            this.stakePeriodStart = stakePeriodStart;
            this.pendingReward = pendingReward;
            this.stakedToMe = stakedToMe;
            this.stakedId = stakedId;
        }

        public StakingInfo build() {
            return new StakingInfo(this.declineReward, this.stakePeriodStart, this.pendingReward, this.stakedToMe, this.stakedId);
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder stakePeriodStart(@Nullable Timestamp stakePeriodStart) {
            this.stakePeriodStart = stakePeriodStart;
            return this;
        }

        public Builder stakePeriodStart(Timestamp.Builder builder) {
            this.stakePeriodStart = builder.build();
            return this;
        }

        public Builder pendingReward(long pendingReward) {
            this.pendingReward = pendingReward;
            return this;
        }

        public Builder stakedToMe(long stakedToMe) {
            this.stakedToMe = stakedToMe;
            return this;
        }

        public void clearStakedId() {
            this.stakedId = StakingInfoProtoCodec.STAKED_ID_UNSET;
        }

        public Builder stakedAccountId(@Nullable AccountID stakedAccountId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public boolean declineReward() {
            return this.declineReward;
        }

        public Timestamp stakePeriodStart() {
            return this.stakePeriodStart;
        }

        public long pendingReward() {
            return this.pendingReward;
        }

        public long stakedToMe() {
            return this.stakedToMe;
        }

        public OneOf<StakedIdOneOfType> stakedId() {
            return this.stakedId;
        }
    }
}

