/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.token.GetAccountDetailsResponse;
import com.hedera.hapi.node.token.GrantedCryptoAllowance;
import com.hedera.hapi.node.token.GrantedNftAllowance;
import com.hedera.hapi.node.token.GrantedTokenAllowance;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GetAccountDetailsResponseJsonCodec
implements JsonCodec<GetAccountDetailsResponse> {
    @NonNull
    public GetAccountDetailsResponse parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ResponseHeader temp_header = null;
            GetAccountDetailsResponse.AccountDetails temp_account_details = null;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "header": {
                        temp_header = (ResponseHeader)ResponseHeader.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block10;
                    }
                    case "accountDetails": {
                        temp_account_details = (GetAccountDetailsResponse.AccountDetails)GetAccountDetailsResponse.AccountDetails.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new GetAccountDetailsResponse(temp_header, temp_account_details);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull GetAccountDetailsResponse data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.header() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"header", ResponseHeader.JSON, (Object)data.header()));
        }
        if (data.accountDetails() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountDetails", GetAccountDetailsResponse.AccountDetails.JSON, (Object)data.accountDetails()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }

    public static final class AccountDetailsJsonCodec
    implements JsonCodec<GetAccountDetailsResponse.AccountDetails> {
        @NonNull
        public GetAccountDetailsResponse.AccountDetails parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
            if (maxDepth < 0) {
                throw new ParseException("Reached maximum allowed depth of nested messages");
            }
            try {
                AccountID temp_account_id = null;
                String temp_contract_account_id = "";
                boolean temp_deleted = false;
                AccountID temp_proxy_account_id = null;
                long temp_proxy_received = 0L;
                Key temp_key = null;
                long temp_balance = 0L;
                boolean temp_receiver_sig_required = false;
                Timestamp temp_expiration_time = null;
                Duration temp_auto_renew_period = null;
                List temp_token_relationships = Collections.emptyList();
                String temp_memo = "";
                long temp_owned_nfts = 0L;
                int temp_max_automatic_token_associations = 0;
                Bytes temp_alias = Bytes.EMPTY;
                Bytes temp_ledger_id = Bytes.EMPTY;
                List temp_granted_crypto_allowances = Collections.emptyList();
                List temp_granted_nft_allowances = Collections.emptyList();
                List temp_granted_token_allowances = Collections.emptyList();
                block44: for (JSONParser.PairContext kvPair : root.pair()) {
                    switch (kvPair.STRING().getText()) {
                        case "accountId": {
                            temp_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                            continue block44;
                        }
                        case "contractAccountId": {
                            temp_contract_account_id = JsonTools.unescape((String)JsonTools.checkSize((String)"contract_account_id", (String)kvPair.value().STRING().getText(), (int)maxSize));
                            continue block44;
                        }
                        case "deleted": {
                            temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "proxyAccountId": {
                            temp_proxy_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                            continue block44;
                        }
                        case "proxyReceived": {
                            temp_proxy_received = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "key": {
                            temp_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                            continue block44;
                        }
                        case "balance": {
                            temp_balance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "receiverSigRequired": {
                            temp_receiver_sig_required = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "expirationTime": {
                            temp_expiration_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                            continue block44;
                        }
                        case "autoRenewPeriod": {
                            temp_auto_renew_period = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                            continue block44;
                        }
                        case "tokenRelationships": {
                            temp_token_relationships = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"token_relationships", (List)kvPair.value().arr().value(), (int)maxSize), TokenRelationship.JSON, (int)(maxDepth - 1), (int)maxSize);
                            continue block44;
                        }
                        case "memo": {
                            temp_memo = JsonTools.unescape((String)JsonTools.checkSize((String)"memo", (String)kvPair.value().STRING().getText(), (int)maxSize));
                            continue block44;
                        }
                        case "ownedNfts": {
                            temp_owned_nfts = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "maxAutomaticTokenAssociations": {
                            temp_max_automatic_token_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                            continue block44;
                        }
                        case "alias": {
                            temp_alias = Bytes.fromBase64((String)JsonTools.checkSize((String)"alias", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                            continue block44;
                        }
                        case "ledgerId": {
                            temp_ledger_id = Bytes.fromBase64((String)JsonTools.checkSize((String)"ledger_id", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                            continue block44;
                        }
                        case "grantedCryptoAllowances": {
                            temp_granted_crypto_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"granted_crypto_allowances", (List)kvPair.value().arr().value(), (int)maxSize), GrantedCryptoAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                            continue block44;
                        }
                        case "grantedNftAllowances": {
                            temp_granted_nft_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"granted_nft_allowances", (List)kvPair.value().arr().value(), (int)maxSize), GrantedNftAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                            continue block44;
                        }
                        case "grantedTokenAllowances": {
                            temp_granted_token_allowances = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"granted_token_allowances", (List)kvPair.value().arr().value(), (int)maxSize), GrantedTokenAllowance.JSON, (int)(maxDepth - 1), (int)maxSize);
                            continue block44;
                        }
                    }
                    if (!strictMode) continue;
                    throw new UnknownFieldException(kvPair.STRING().getText());
                }
                return new GetAccountDetailsResponse.AccountDetails(temp_account_id, temp_contract_account_id, temp_deleted, temp_proxy_account_id, temp_proxy_received, temp_key, temp_balance, temp_receiver_sig_required, temp_expiration_time, temp_auto_renew_period, temp_token_relationships, temp_memo, temp_owned_nfts, temp_max_automatic_token_associations, temp_alias, temp_ledger_id, temp_granted_crypto_allowances, temp_granted_nft_allowances, temp_granted_token_allowances);
            }
            catch (Exception ex) {
                throw new ParseException((Throwable)ex);
            }
        }

        public String toJSON(@NonNull GetAccountDetailsResponse.AccountDetails data, String indent, boolean inline) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)(inline ? "{\n" : indent + "{\n"));
            String childIndent = indent + "  ";
            ArrayList<String> fieldLines = new ArrayList<String>();
            if (data.accountId() != null) {
                fieldLines.add(JsonTools.field((String)childIndent, (String)"accountId", AccountID.JSON, (Object)data.accountId()));
            }
            if (data.contractAccountId() != null && !data.contractAccountId().isEmpty()) {
                fieldLines.add(JsonTools.field((String)"contractAccountId", (String)data.contractAccountId()));
            }
            if (data.deleted()) {
                fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
            }
            if (data.proxyAccountId() != null) {
                fieldLines.add(JsonTools.field((String)childIndent, (String)"proxyAccountId", AccountID.JSON, (Object)data.proxyAccountId()));
            }
            if (data.proxyReceived() != 0L) {
                fieldLines.add(JsonTools.field((String)"proxyReceived", (long)data.proxyReceived()));
            }
            if (data.key() != null) {
                fieldLines.add(JsonTools.field((String)childIndent, (String)"key", Key.JSON, (Object)data.key()));
            }
            if (data.balance() != 0L) {
                fieldLines.add(JsonTools.field((String)"balance", (long)data.balance()));
            }
            if (data.receiverSigRequired()) {
                fieldLines.add(JsonTools.field((String)"receiverSigRequired", (boolean)data.receiverSigRequired()));
            }
            if (data.expirationTime() != null) {
                fieldLines.add(JsonTools.field((String)childIndent, (String)"expirationTime", Timestamp.JSON, (Object)data.expirationTime()));
            }
            if (data.autoRenewPeriod() != null) {
                fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
            }
            if (!data.tokenRelationships().isEmpty()) {
                fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenRelationships", TokenRelationship.JSON, data.tokenRelationships()));
            }
            if (data.memo() != null && !data.memo().isEmpty()) {
                fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
            }
            if (data.ownedNfts() != 0L) {
                fieldLines.add(JsonTools.field((String)"ownedNfts", (long)data.ownedNfts()));
            }
            if (data.maxAutomaticTokenAssociations() != 0) {
                fieldLines.add(JsonTools.field((String)"maxAutomaticTokenAssociations", (int)data.maxAutomaticTokenAssociations()));
            }
            if (data.alias() != Bytes.EMPTY && data.alias() != null && data.alias().length() > 0L) {
                fieldLines.add(JsonTools.field((String)"alias", (Bytes)data.alias()));
            }
            if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
                fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
            }
            if (!data.grantedCryptoAllowances().isEmpty()) {
                fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"grantedCryptoAllowances", GrantedCryptoAllowance.JSON, data.grantedCryptoAllowances()));
            }
            if (!data.grantedNftAllowances().isEmpty()) {
                fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"grantedNftAllowances", GrantedNftAllowance.JSON, data.grantedNftAllowances()));
            }
            if (!data.grantedTokenAllowances().isEmpty()) {
                fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"grantedTokenAllowances", GrantedTokenAllowance.JSON, data.grantedTokenAllowances()));
            }
            if (!fieldLines.isEmpty()) {
                sb.append(childIndent);
                sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
                sb.append("\n");
            }
            sb.append(indent + "}");
            return sb.toString();
        }
    }
}

