/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.CallOperationType;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.hapi.streams.codec.ContractActionJsonCodec;
import com.hedera.hapi.streams.codec.ContractActionProtoCodec;
import com.hedera.hapi.streams.schema.ContractActionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ContractAction {
    public static final Codec<ContractAction> PROTOBUF = new ContractActionProtoCodec();
    public static final JsonCodec<ContractAction> JSON = new ContractActionJsonCodec();
    public static final ContractAction DEFAULT = ContractAction.newBuilder().build();
    private final ContractActionType callType;
    private final OneOf<CallerOneOfType> caller;
    private final long gas;
    @NonNull
    private final Bytes input;
    private final OneOf<RecipientOneOfType> recipient;
    private final long value;
    private final long gasUsed;
    private final OneOf<ResultDataOneOfType> resultData;
    private final int callDepth;
    private final CallOperationType callOperationType;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ContractAction(ContractActionType callType, OneOf<CallerOneOfType> caller, long gas, Bytes input, OneOf<RecipientOneOfType> recipient, long value, long gasUsed, OneOf<ResultDataOneOfType> resultData, int callDepth, CallOperationType callOperationType) {
        this.$unknownFields = null;
        this.callType = callType;
        if (caller == null) {
            throw new NullPointerException("Parameter 'caller' must be supplied and can not be null");
        }
        this.caller = caller;
        this.gas = gas;
        Bytes bytes = this.input = input != null ? input : Bytes.EMPTY;
        if (recipient == null) {
            throw new NullPointerException("Parameter 'recipient' must be supplied and can not be null");
        }
        this.recipient = recipient;
        this.value = value;
        this.gasUsed = gasUsed;
        if (resultData == null) {
            throw new NullPointerException("Parameter 'resultData' must be supplied and can not be null");
        }
        this.resultData = resultData;
        this.callDepth = callDepth;
        this.callOperationType = callOperationType;
    }

    public ContractAction(ContractActionType callType, OneOf<CallerOneOfType> caller, long gas, Bytes input, OneOf<RecipientOneOfType> recipient, long value, long gasUsed, OneOf<ResultDataOneOfType> resultData, int callDepth, CallOperationType callOperationType, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.callType = callType;
        if (caller == null) {
            throw new NullPointerException("Parameter 'caller' must be supplied and can not be null");
        }
        this.caller = caller;
        this.gas = gas;
        Bytes bytes = this.input = input != null ? input : Bytes.EMPTY;
        if (recipient == null) {
            throw new NullPointerException("Parameter 'recipient' must be supplied and can not be null");
        }
        this.recipient = recipient;
        this.value = value;
        this.gasUsed = gasUsed;
        if (resultData == null) {
            throw new NullPointerException("Parameter 'resultData' must be supplied and can not be null");
        }
        this.resultData = resultData;
        this.callDepth = callDepth;
        this.callOperationType = callOperationType;
    }

    public ContractActionType callType() {
        return this.callType;
    }

    public OneOf<CallerOneOfType> caller() {
        return this.caller;
    }

    public long gas() {
        return this.gas;
    }

    public Bytes input() {
        return this.input;
    }

    public OneOf<RecipientOneOfType> recipient() {
        return this.recipient;
    }

    public long value() {
        return this.value;
    }

    public long gasUsed() {
        return this.gasUsed;
    }

    public OneOf<ResultDataOneOfType> resultData() {
        return this.resultData;
    }

    public int callDepth() {
        return this.callDepth;
    }

    public CallOperationType callOperationType() {
        return this.callOperationType;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ContractActionSchema.CALL_TYPE, (EnumWithProtoMetadata)this.callType);
            if (this.caller.kind() == CallerOneOfType.CALLING_ACCOUNT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.CALLING_ACCOUNT, (Object)((AccountID)this.caller.as()), AccountID.PROTOBUF);
            }
            if (this.caller.kind() == CallerOneOfType.CALLING_CONTRACT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.CALLING_CONTRACT, (Object)((ContractID)this.caller.as()), ContractID.PROTOBUF);
            }
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.GAS, (long)this.gas, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.INPUT, (RandomAccessData)this.input, (boolean)true);
            if (this.recipient.kind() == RecipientOneOfType.RECIPIENT_ACCOUNT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.RECIPIENT_ACCOUNT, (Object)((AccountID)this.recipient.as()), AccountID.PROTOBUF);
            }
            if (this.recipient.kind() == RecipientOneOfType.RECIPIENT_CONTRACT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.RECIPIENT_CONTRACT, (Object)((ContractID)this.recipient.as()), ContractID.PROTOBUF);
            }
            if (this.recipient.kind() == RecipientOneOfType.TARGETED_ADDRESS) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.TARGETED_ADDRESS, (RandomAccessData)((RandomAccessData)this.recipient.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.VALUE, (long)this.value, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.GAS_USED, (long)this.gasUsed, (boolean)true);
            if (this.resultData.kind() == ResultDataOneOfType.OUTPUT) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.OUTPUT, (RandomAccessData)((RandomAccessData)this.resultData.as()), (boolean)true);
            }
            if (this.resultData.kind() == ResultDataOneOfType.REVERT_REASON) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.REVERT_REASON, (RandomAccessData)((RandomAccessData)this.resultData.as()), (boolean)true);
            }
            if (this.resultData.kind() == ResultDataOneOfType.ERROR) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.ERROR, (RandomAccessData)((RandomAccessData)this.resultData.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ContractActionSchema.CALL_DEPTH, (int)this.callDepth, (boolean)true);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ContractActionSchema.CALL_OPERATION_TYPE, (EnumWithProtoMetadata)this.callOperationType);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.callType != null && !this.callType.equals((Object)ContractAction.DEFAULT.callType)) {
                result = 31 * result + Integer.hashCode(this.callType.protoOrdinal());
            }
            if (this.caller != null && !this.caller.equals(ContractAction.DEFAULT.caller)) {
                result = 31 * result + this.caller.hashCode();
            }
            if (this.gas != ContractAction.DEFAULT.gas) {
                result = 31 * result + Long.hashCode(this.gas);
            }
            if (this.input != null && !this.input.equals((Object)ContractAction.DEFAULT.input)) {
                result = 31 * result + this.input.hashCode();
            }
            if (this.recipient != null && !this.recipient.equals(ContractAction.DEFAULT.recipient)) {
                result = 31 * result + this.recipient.hashCode();
            }
            if (this.value != ContractAction.DEFAULT.value) {
                result = 31 * result + Long.hashCode(this.value);
            }
            if (this.gasUsed != ContractAction.DEFAULT.gasUsed) {
                result = 31 * result + Long.hashCode(this.gasUsed);
            }
            if (this.resultData != null && !this.resultData.equals(ContractAction.DEFAULT.resultData)) {
                result = 31 * result + this.resultData.hashCode();
            }
            if (this.callDepth != ContractAction.DEFAULT.callDepth) {
                result = 31 * result + Integer.hashCode(this.callDepth);
            }
            if (this.callOperationType != null && !this.callOperationType.equals((Object)ContractAction.DEFAULT.callOperationType)) {
                result = 31 * result + Integer.hashCode(this.callOperationType.protoOrdinal());
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractAction thatObj = (ContractAction)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.callType == null && thatObj.callType != null) {
            return false;
        }
        if (this.callType != null && !this.callType.equals((Object)thatObj.callType)) {
            return false;
        }
        if (this.caller == null && thatObj.caller != null) {
            return false;
        }
        if (this.caller != null && !this.caller.equals(thatObj.caller)) {
            return false;
        }
        if (this.gas != thatObj.gas) {
            return false;
        }
        if (this.input == null && thatObj.input != null) {
            return false;
        }
        if (this.input != null && !this.input.equals((Object)thatObj.input)) {
            return false;
        }
        if (this.recipient == null && thatObj.recipient != null) {
            return false;
        }
        if (this.recipient != null && !this.recipient.equals(thatObj.recipient)) {
            return false;
        }
        if (this.value != thatObj.value) {
            return false;
        }
        if (this.gasUsed != thatObj.gasUsed) {
            return false;
        }
        if (this.resultData == null && thatObj.resultData != null) {
            return false;
        }
        if (this.resultData != null && !this.resultData.equals(thatObj.resultData)) {
            return false;
        }
        if (this.callDepth != thatObj.callDepth) {
            return false;
        }
        if (this.callOperationType == null && thatObj.callOperationType != null) {
            return false;
        }
        if (this.callOperationType != null && !this.callOperationType.equals((Object)thatObj.callOperationType)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ContractAction[callType=" + String.valueOf((Object)this.callType) + ", caller=" + String.valueOf(this.caller) + ", gas=" + this.gas + ", input=" + String.valueOf(this.input) + ", recipient=" + String.valueOf(this.recipient) + ", value=" + this.value + ", gasUsed=" + this.gasUsed + ", resultData=" + String.valueOf(this.resultData) + ", callDepth=" + this.callDepth + ", callOperationType=" + String.valueOf((Object)this.callOperationType) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public AccountID callingAccount() {
        return this.caller.kind() == CallerOneOfType.CALLING_ACCOUNT ? (AccountID)this.caller.value() : null;
    }

    public boolean hasCallingAccount() {
        return this.caller.kind() == CallerOneOfType.CALLING_ACCOUNT;
    }

    public AccountID callingAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasCallingAccount() ? this.callingAccount() : defaultValue;
    }

    @NonNull
    public AccountID callingAccountOrThrow() {
        return Objects.requireNonNull(this.callingAccount(), "Field callingAccount is null");
    }

    @Nullable
    public ContractID callingContract() {
        return this.caller.kind() == CallerOneOfType.CALLING_CONTRACT ? (ContractID)this.caller.value() : null;
    }

    public boolean hasCallingContract() {
        return this.caller.kind() == CallerOneOfType.CALLING_CONTRACT;
    }

    public ContractID callingContractOrElse(@NonNull ContractID defaultValue) {
        return this.hasCallingContract() ? this.callingContract() : defaultValue;
    }

    @NonNull
    public ContractID callingContractOrThrow() {
        return Objects.requireNonNull(this.callingContract(), "Field callingContract is null");
    }

    @Nullable
    public AccountID recipientAccount() {
        return this.recipient.kind() == RecipientOneOfType.RECIPIENT_ACCOUNT ? (AccountID)this.recipient.value() : null;
    }

    public boolean hasRecipientAccount() {
        return this.recipient.kind() == RecipientOneOfType.RECIPIENT_ACCOUNT;
    }

    public AccountID recipientAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasRecipientAccount() ? this.recipientAccount() : defaultValue;
    }

    @NonNull
    public AccountID recipientAccountOrThrow() {
        return Objects.requireNonNull(this.recipientAccount(), "Field recipientAccount is null");
    }

    @Nullable
    public ContractID recipientContract() {
        return this.recipient.kind() == RecipientOneOfType.RECIPIENT_CONTRACT ? (ContractID)this.recipient.value() : null;
    }

    public boolean hasRecipientContract() {
        return this.recipient.kind() == RecipientOneOfType.RECIPIENT_CONTRACT;
    }

    public ContractID recipientContractOrElse(@NonNull ContractID defaultValue) {
        return this.hasRecipientContract() ? this.recipientContract() : defaultValue;
    }

    @NonNull
    public ContractID recipientContractOrThrow() {
        return Objects.requireNonNull(this.recipientContract(), "Field recipientContract is null");
    }

    @Nullable
    public Bytes targetedAddress() {
        return this.recipient.kind() == RecipientOneOfType.TARGETED_ADDRESS ? (Bytes)this.recipient.value() : null;
    }

    public boolean hasTargetedAddress() {
        return this.recipient.kind() == RecipientOneOfType.TARGETED_ADDRESS;
    }

    public Bytes targetedAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasTargetedAddress() ? this.targetedAddress() : defaultValue;
    }

    @NonNull
    public Bytes targetedAddressOrThrow() {
        return Objects.requireNonNull(this.targetedAddress(), "Field targetedAddress is null");
    }

    @Nullable
    public Bytes output() {
        return this.resultData.kind() == ResultDataOneOfType.OUTPUT ? (Bytes)this.resultData.value() : null;
    }

    public boolean hasOutput() {
        return this.resultData.kind() == ResultDataOneOfType.OUTPUT;
    }

    public Bytes outputOrElse(@NonNull Bytes defaultValue) {
        return this.hasOutput() ? this.output() : defaultValue;
    }

    @NonNull
    public Bytes outputOrThrow() {
        return Objects.requireNonNull(this.output(), "Field output is null");
    }

    @Nullable
    public Bytes revertReason() {
        return this.resultData.kind() == ResultDataOneOfType.REVERT_REASON ? (Bytes)this.resultData.value() : null;
    }

    public boolean hasRevertReason() {
        return this.resultData.kind() == ResultDataOneOfType.REVERT_REASON;
    }

    public Bytes revertReasonOrElse(@NonNull Bytes defaultValue) {
        return this.hasRevertReason() ? this.revertReason() : defaultValue;
    }

    @NonNull
    public Bytes revertReasonOrThrow() {
        return Objects.requireNonNull(this.revertReason(), "Field revertReason is null");
    }

    @Nullable
    public Bytes error() {
        return this.resultData.kind() == ResultDataOneOfType.ERROR ? (Bytes)this.resultData.value() : null;
    }

    public boolean hasError() {
        return this.resultData.kind() == ResultDataOneOfType.ERROR;
    }

    public Bytes errorOrElse(@NonNull Bytes defaultValue) {
        return this.hasError() ? this.error() : defaultValue;
    }

    @NonNull
    public Bytes errorOrThrow() {
        return Objects.requireNonNull(this.error(), "Field error is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.callType, this.caller, this.gas, this.input, this.recipient, this.value, this.gasUsed, this.resultData, this.callDepth, this.callOperationType, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum CallerOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CALLING_ACCOUNT(2, "calling_account"),
        CALLING_CONTRACT(3, "calling_contract");

        private final int protoOrdinal;
        private final String protoName;

        private CallerOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static CallerOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> CALLING_ACCOUNT;
                case 3 -> CALLING_CONTRACT;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static CallerOneOfType fromString(String name) {
            return switch (name) {
                case "calling_account", "CALLING_ACCOUNT" -> CALLING_ACCOUNT;
                case "calling_contract", "CALLING_CONTRACT" -> CALLING_CONTRACT;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum RecipientOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        RECIPIENT_ACCOUNT(6, "recipient_account"),
        RECIPIENT_CONTRACT(7, "recipient_contract"),
        TARGETED_ADDRESS(8, "targeted_address");

        private final int protoOrdinal;
        private final String protoName;

        private RecipientOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static RecipientOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 6 -> RECIPIENT_ACCOUNT;
                case 7 -> RECIPIENT_CONTRACT;
                case 8 -> TARGETED_ADDRESS;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static RecipientOneOfType fromString(String name) {
            return switch (name) {
                case "recipient_account", "RECIPIENT_ACCOUNT" -> RECIPIENT_ACCOUNT;
                case "recipient_contract", "RECIPIENT_CONTRACT" -> RECIPIENT_CONTRACT;
                case "targeted_address", "TARGETED_ADDRESS" -> TARGETED_ADDRESS;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum ResultDataOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        OUTPUT(11, "output"),
        REVERT_REASON(12, "revert_reason"),
        ERROR(13, "error");

        private final int protoOrdinal;
        private final String protoName;

        private ResultDataOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ResultDataOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 11 -> OUTPUT;
                case 12 -> REVERT_REASON;
                case 13 -> ERROR;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ResultDataOneOfType fromString(String name) {
            return switch (name) {
                case "output", "OUTPUT" -> OUTPUT;
                case "revert_reason", "REVERT_REASON" -> REVERT_REASON;
                case "error", "ERROR" -> ERROR;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private ContractActionType callType = ContractActionType.fromProtobufOrdinal(0);
        private OneOf<CallerOneOfType> caller = ContractActionProtoCodec.CALLER_UNSET;
        private long gas = 0L;
        @NonNull
        private Bytes input = Bytes.EMPTY;
        private OneOf<RecipientOneOfType> recipient = ContractActionProtoCodec.RECIPIENT_UNSET;
        private long value = 0L;
        private long gasUsed = 0L;
        private OneOf<ResultDataOneOfType> resultData = ContractActionProtoCodec.RESULT_DATA_UNSET;
        private int callDepth = 0;
        private CallOperationType callOperationType = CallOperationType.fromProtobufOrdinal(0);
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(ContractActionType callType, OneOf<CallerOneOfType> caller, long gas, Bytes input, OneOf<RecipientOneOfType> recipient, long value, long gasUsed, OneOf<ResultDataOneOfType> resultData, int callDepth, CallOperationType callOperationType) {
            this.$unknownFields = null;
            this.callType = callType;
            this.caller = caller;
            this.gas = gas;
            this.input = input != null ? input : Bytes.EMPTY;
            this.recipient = recipient;
            this.value = value;
            this.gasUsed = gasUsed;
            this.resultData = resultData;
            this.callDepth = callDepth;
            this.callOperationType = callOperationType;
        }

        public Builder(ContractActionType callType, OneOf<CallerOneOfType> caller, long gas, Bytes input, OneOf<RecipientOneOfType> recipient, long value, long gasUsed, OneOf<ResultDataOneOfType> resultData, int callDepth, CallOperationType callOperationType, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.callType = callType;
            this.caller = caller;
            this.gas = gas;
            this.input = input != null ? input : Bytes.EMPTY;
            this.recipient = recipient;
            this.value = value;
            this.gasUsed = gasUsed;
            this.resultData = resultData;
            this.callDepth = callDepth;
            this.callOperationType = callOperationType;
        }

        public ContractAction build() {
            return new ContractAction(this.callType, this.caller, this.gas, this.input, this.recipient, this.value, this.gasUsed, this.resultData, this.callDepth, this.callOperationType);
        }

        public Builder callType(ContractActionType callType) {
            this.callType = callType;
            return this;
        }

        public void clearCaller() {
            this.caller = ContractActionProtoCodec.CALLER_UNSET;
        }

        public Builder callingAccount(@Nullable AccountID callingAccount) {
            this.caller = new OneOf((Enum)CallerOneOfType.CALLING_ACCOUNT, (Object)callingAccount);
            return this;
        }

        public Builder callingAccount(AccountID.Builder builder) {
            this.caller = new OneOf((Enum)CallerOneOfType.CALLING_ACCOUNT, (Object)builder.build());
            return this;
        }

        public Builder callingContract(@Nullable ContractID callingContract) {
            this.caller = new OneOf((Enum)CallerOneOfType.CALLING_CONTRACT, (Object)callingContract);
            return this;
        }

        public Builder callingContract(ContractID.Builder builder) {
            this.caller = new OneOf((Enum)CallerOneOfType.CALLING_CONTRACT, (Object)builder.build());
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder input(@NonNull Bytes input) {
            this.input = input != null ? input : Bytes.EMPTY;
            return this;
        }

        public void clearRecipient() {
            this.recipient = ContractActionProtoCodec.RECIPIENT_UNSET;
        }

        public Builder recipientAccount(@Nullable AccountID recipientAccount) {
            this.recipient = new OneOf((Enum)RecipientOneOfType.RECIPIENT_ACCOUNT, (Object)recipientAccount);
            return this;
        }

        public Builder recipientAccount(AccountID.Builder builder) {
            this.recipient = new OneOf((Enum)RecipientOneOfType.RECIPIENT_ACCOUNT, (Object)builder.build());
            return this;
        }

        public Builder recipientContract(@Nullable ContractID recipientContract) {
            this.recipient = new OneOf((Enum)RecipientOneOfType.RECIPIENT_CONTRACT, (Object)recipientContract);
            return this;
        }

        public Builder recipientContract(ContractID.Builder builder) {
            this.recipient = new OneOf((Enum)RecipientOneOfType.RECIPIENT_CONTRACT, (Object)builder.build());
            return this;
        }

        public Builder targetedAddress(@NonNull Bytes targetedAddress) {
            this.recipient = new OneOf((Enum)RecipientOneOfType.TARGETED_ADDRESS, (Object)targetedAddress);
            return this;
        }

        public Builder value(long value) {
            this.value = value;
            return this;
        }

        public Builder gasUsed(long gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public void clearResultData() {
            this.resultData = ContractActionProtoCodec.RESULT_DATA_UNSET;
        }

        public Builder output(@NonNull Bytes output) {
            this.resultData = new OneOf((Enum)ResultDataOneOfType.OUTPUT, (Object)output);
            return this;
        }

        public Builder revertReason(@NonNull Bytes revertReason) {
            this.resultData = new OneOf((Enum)ResultDataOneOfType.REVERT_REASON, (Object)revertReason);
            return this;
        }

        public Builder error(@NonNull Bytes error) {
            this.resultData = new OneOf((Enum)ResultDataOneOfType.ERROR, (Object)error);
            return this;
        }

        public Builder callDepth(int callDepth) {
            this.callDepth = callDepth;
            return this;
        }

        public Builder callOperationType(CallOperationType callOperationType) {
            this.callOperationType = callOperationType;
            return this;
        }

        public ContractActionType callType() {
            return this.callType;
        }

        public OneOf<CallerOneOfType> caller() {
            return this.caller;
        }

        public long gas() {
            return this.gas;
        }

        public Bytes input() {
            return this.input;
        }

        public OneOf<RecipientOneOfType> recipient() {
            return this.recipient;
        }

        public long value() {
            return this.value;
        }

        public long gasUsed() {
            return this.gasUsed;
        }

        public OneOf<ResultDataOneOfType> resultData() {
            return this.resultData;
        }

        public int callDepth() {
            return this.callDepth;
        }

        public CallOperationType callOperationType() {
            return this.callOperationType;
        }
    }
}

