/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.streams.ContractActions;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.hapi.streams.codec.TransactionSidecarRecordJsonCodec;
import com.hedera.hapi.streams.codec.TransactionSidecarRecordProtoCodec;
import com.hedera.hapi.streams.schema.TransactionSidecarRecordSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TransactionSidecarRecord {
    public static final Codec<TransactionSidecarRecord> PROTOBUF = new TransactionSidecarRecordProtoCodec();
    public static final JsonCodec<TransactionSidecarRecord> JSON = new TransactionSidecarRecordJsonCodec();
    public static final TransactionSidecarRecord DEFAULT = TransactionSidecarRecord.newBuilder().build();
    @Nullable
    private final Timestamp consensusTimestamp;
    private final boolean migration;
    private final OneOf<SidecarRecordsOneOfType> sidecarRecords;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TransactionSidecarRecord(Timestamp consensusTimestamp, boolean migration, OneOf<SidecarRecordsOneOfType> sidecarRecords) {
        this.$unknownFields = null;
        this.consensusTimestamp = consensusTimestamp;
        this.migration = migration;
        if (sidecarRecords == null) {
            throw new NullPointerException("Parameter 'sidecarRecords' must be supplied and can not be null");
        }
        this.sidecarRecords = sidecarRecords;
    }

    public TransactionSidecarRecord(Timestamp consensusTimestamp, boolean migration, OneOf<SidecarRecordsOneOfType> sidecarRecords, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.consensusTimestamp = consensusTimestamp;
        this.migration = migration;
        if (sidecarRecords == null) {
            throw new NullPointerException("Parameter 'sidecarRecords' must be supplied and can not be null");
        }
        this.sidecarRecords = sidecarRecords;
    }

    public Timestamp consensusTimestamp() {
        return this.consensusTimestamp;
    }

    public boolean migration() {
        return this.migration;
    }

    public OneOf<SidecarRecordsOneOfType> sidecarRecords() {
        return this.sidecarRecords;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.CONSENSUS_TIMESTAMP, (Object)this.consensusTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TransactionSidecarRecordSchema.MIGRATION, (boolean)this.migration, (boolean)true);
            if (this.sidecarRecords.kind() == SidecarRecordsOneOfType.STATE_CHANGES) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.STATE_CHANGES, (Object)((ContractStateChanges)this.sidecarRecords.as()), ContractStateChanges.PROTOBUF);
            }
            if (this.sidecarRecords.kind() == SidecarRecordsOneOfType.ACTIONS) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.ACTIONS, (Object)((ContractActions)this.sidecarRecords.as()), ContractActions.PROTOBUF);
            }
            if (this.sidecarRecords.kind() == SidecarRecordsOneOfType.BYTECODE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.BYTECODE, (Object)((ContractBytecode)this.sidecarRecords.as()), ContractBytecode.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(TransactionSidecarRecord.DEFAULT.consensusTimestamp)) {
                result = 31 * result + this.consensusTimestamp.hashCode();
            }
            if (this.migration != TransactionSidecarRecord.DEFAULT.migration) {
                result = 31 * result + Boolean.hashCode(this.migration);
            }
            if (this.sidecarRecords != null && !this.sidecarRecords.equals(TransactionSidecarRecord.DEFAULT.sidecarRecords)) {
                result = 31 * result + this.sidecarRecords.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionSidecarRecord thatObj = (TransactionSidecarRecord)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.consensusTimestamp == null && thatObj.consensusTimestamp != null) {
            return false;
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(thatObj.consensusTimestamp)) {
            return false;
        }
        if (this.migration != thatObj.migration) {
            return false;
        }
        if (this.sidecarRecords == null && thatObj.sidecarRecords != null) {
            return false;
        }
        if (this.sidecarRecords != null && !this.sidecarRecords.equals(thatObj.sidecarRecords)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TransactionSidecarRecord[consensusTimestamp=" + String.valueOf(this.consensusTimestamp) + ", migration=" + this.migration + ", sidecarRecords=" + String.valueOf(this.sidecarRecords) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasConsensusTimestamp() {
        return this.consensusTimestamp != null;
    }

    public Timestamp consensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsensusTimestamp() ? this.consensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp consensusTimestampOrThrow() {
        return Objects.requireNonNull(this.consensusTimestamp, "Field consensusTimestamp is null");
    }

    public void ifConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsensusTimestamp()) {
            ifPresent.accept(this.consensusTimestamp);
        }
    }

    @Nullable
    public ContractStateChanges stateChanges() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.STATE_CHANGES ? (ContractStateChanges)this.sidecarRecords.value() : null;
    }

    public boolean hasStateChanges() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.STATE_CHANGES;
    }

    public ContractStateChanges stateChangesOrElse(@NonNull ContractStateChanges defaultValue) {
        return this.hasStateChanges() ? this.stateChanges() : defaultValue;
    }

    @NonNull
    public ContractStateChanges stateChangesOrThrow() {
        return Objects.requireNonNull(this.stateChanges(), "Field stateChanges is null");
    }

    @Nullable
    public ContractActions actions() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.ACTIONS ? (ContractActions)this.sidecarRecords.value() : null;
    }

    public boolean hasActions() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.ACTIONS;
    }

    public ContractActions actionsOrElse(@NonNull ContractActions defaultValue) {
        return this.hasActions() ? this.actions() : defaultValue;
    }

    @NonNull
    public ContractActions actionsOrThrow() {
        return Objects.requireNonNull(this.actions(), "Field actions is null");
    }

    @Nullable
    public ContractBytecode bytecode() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.BYTECODE ? (ContractBytecode)this.sidecarRecords.value() : null;
    }

    public boolean hasBytecode() {
        return this.sidecarRecords.kind() == SidecarRecordsOneOfType.BYTECODE;
    }

    public ContractBytecode bytecodeOrElse(@NonNull ContractBytecode defaultValue) {
        return this.hasBytecode() ? this.bytecode() : defaultValue;
    }

    @NonNull
    public ContractBytecode bytecodeOrThrow() {
        return Objects.requireNonNull(this.bytecode(), "Field bytecode is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.consensusTimestamp, this.migration, this.sidecarRecords, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum SidecarRecordsOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STATE_CHANGES(3, "state_changes"),
        ACTIONS(4, "actions"),
        BYTECODE(5, "bytecode");

        private final int protoOrdinal;
        private final String protoName;

        private SidecarRecordsOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static SidecarRecordsOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> STATE_CHANGES;
                case 4 -> ACTIONS;
                case 5 -> BYTECODE;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static SidecarRecordsOneOfType fromString(String name) {
            return switch (name) {
                case "state_changes", "STATE_CHANGES" -> STATE_CHANGES;
                case "actions", "ACTIONS" -> ACTIONS;
                case "bytecode", "BYTECODE" -> BYTECODE;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private Timestamp consensusTimestamp = null;
        private boolean migration = false;
        private OneOf<SidecarRecordsOneOfType> sidecarRecords = TransactionSidecarRecordProtoCodec.SIDECAR_RECORDS_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Timestamp consensusTimestamp, boolean migration, OneOf<SidecarRecordsOneOfType> sidecarRecords) {
            this.$unknownFields = null;
            this.consensusTimestamp = consensusTimestamp;
            this.migration = migration;
            this.sidecarRecords = sidecarRecords;
        }

        public Builder(Timestamp consensusTimestamp, boolean migration, OneOf<SidecarRecordsOneOfType> sidecarRecords, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.consensusTimestamp = consensusTimestamp;
            this.migration = migration;
            this.sidecarRecords = sidecarRecords;
        }

        public TransactionSidecarRecord build() {
            return new TransactionSidecarRecord(this.consensusTimestamp, this.migration, this.sidecarRecords);
        }

        public Builder consensusTimestamp(@Nullable Timestamp consensusTimestamp) {
            this.consensusTimestamp = consensusTimestamp;
            return this;
        }

        public Builder consensusTimestamp(Timestamp.Builder builder) {
            this.consensusTimestamp = builder.build();
            return this;
        }

        public Builder migration(boolean migration) {
            this.migration = migration;
            return this;
        }

        public void clearSidecarRecords() {
            this.sidecarRecords = TransactionSidecarRecordProtoCodec.SIDECAR_RECORDS_UNSET;
        }

        public Builder stateChanges(@Nullable ContractStateChanges stateChanges) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.STATE_CHANGES, (Object)stateChanges);
            return this;
        }

        public Builder stateChanges(ContractStateChanges.Builder builder) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.STATE_CHANGES, (Object)builder.build());
            return this;
        }

        public Builder actions(@Nullable ContractActions actions) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.ACTIONS, (Object)actions);
            return this;
        }

        public Builder actions(ContractActions.Builder builder) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.ACTIONS, (Object)builder.build());
            return this;
        }

        public Builder bytecode(@Nullable ContractBytecode bytecode) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.BYTECODE, (Object)bytecode);
            return this;
        }

        public Builder bytecode(ContractBytecode.Builder builder) {
            this.sidecarRecords = new OneOf((Enum)SidecarRecordsOneOfType.BYTECODE, (Object)builder.build());
            return this;
        }

        public Timestamp consensusTimestamp() {
            return this.consensusTimestamp;
        }

        public boolean migration() {
            return this.migration;
        }

        public OneOf<SidecarRecordsOneOfType> sidecarRecords() {
            return this.sidecarRecords;
        }
    }
}

