/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import org.hiero.block.api.ReconnectRequest;
import org.hiero.block.api.ReconnectResponse;

public interface ReconnectServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "ReconnectService";
    public static final String FULL_NAME = "org.hiero.block.api.ReconnectService";

    public void reconnect(@NonNull ReconnectRequest var1, @NonNull Pipeline<? super ReconnectResponse> var2);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(ReconnectServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        ReconnectServiceMethod m = (ReconnectServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.serverStreaming().mapRequest(bytes -> ReconnectServiceInterface.parseReconnectRequest(bytes, options)).method(this::reconnect).mapResponse(reply -> ReconnectServiceInterface.serializeReconnectResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<ReconnectRequest> getReconnectRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return ReconnectRequest.JSON;
        }
        return ReconnectRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<ReconnectResponse> getReconnectResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return ReconnectResponse.JSON;
        }
        return ReconnectResponse.PROTOBUF;
    }

    @NonNull
    private static ReconnectRequest parseReconnectRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (ReconnectRequest)ReconnectServiceInterface.getReconnectRequestCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Bytes serializeReconnectResponse(@NonNull ReconnectResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return ReconnectServiceInterface.getReconnectResponseCodec(options).toBytes((Object)reply);
    }

    public static enum ReconnectServiceMethod implements ServiceInterface.Method
    {
        reconnect;

    }

    public static class ReconnectServiceClient
    implements ReconnectServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public ReconnectServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        public void reconnect(@NonNull ReconnectRequest request, final @NonNull Pipeline<? super ReconnectResponse> replies) {
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<ReconnectResponse> pipeline = new Pipeline<ReconnectResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    replies.onSubscribe(subscription);
                }

                public void onNext(ReconnectResponse reply) {
                    replies.onNext((Object)reply);
                }

                public void onError(Throwable throwable) {
                    replies.onError(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    replies.onComplete();
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.ReconnectService/reconnect", ReconnectServiceInterface.getReconnectRequestCodec(this.requestOptions), ReconnectServiceInterface.getReconnectResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

