/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.linking;

import com.swirlds.platform.event.EventCounter;
import com.swirlds.platform.event.linking.LinkerLogsAndMetrics;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class ConsensusLinker {
    private static final int INITIAL_CAPACITY = 1024;
    private final LinkerLogsAndMetrics logsAndMetrics;
    private final SequenceMap<EventDescriptorWrapper, EventImpl> parentDescriptorMap;
    private final Map<Hash, EventImpl> parentHashMap = new HashMap<Hash, EventImpl>(1024);
    private EventWindow eventWindow;

    public ConsensusLinker(@NonNull LinkerLogsAndMetrics logsAndMetrics) {
        this.logsAndMetrics = logsAndMetrics;
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.parentDescriptorMap = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
    }

    @Nullable
    public EventImpl linkEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            return null;
        }
        List<EventImpl> parents = event.getAllParents().stream().map(ed -> this.getParentToLink(event, (EventDescriptorWrapper)ed)).filter(Objects::nonNull).toList();
        EventImpl linkedEvent = new EventImpl(event, parents);
        EventCounter.incrementLinkedEventCount();
        EventDescriptorWrapper eventDescriptorWrapper = event.getDescriptor();
        this.parentDescriptorMap.put((Object)eventDescriptorWrapper, (Object)linkedEvent);
        this.parentHashMap.put(eventDescriptorWrapper.hash(), linkedEvent);
        return linkedEvent;
    }

    public final List<EventImpl> setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        ArrayList<EventImpl> ancientEvents = new ArrayList<EventImpl>();
        this.parentDescriptorMap.shiftWindow(eventWindow.ancientThreshold(), (descriptor, event) -> {
            this.parentHashMap.remove(descriptor.hash());
            event.clear();
            ancientEvents.add((EventImpl)event);
        });
        return ancientEvents;
    }

    @NonNull
    public List<EventImpl> getNonAncientEvents() {
        return this.parentHashMap.values().stream().toList();
    }

    public void clear() {
        this.parentDescriptorMap.clear();
        this.parentHashMap.clear();
    }

    @Nullable
    private EventImpl getParentToLink(@NonNull PlatformEvent child, @Nullable EventDescriptorWrapper parentDescriptor) {
        if (parentDescriptor == null) {
            return null;
        }
        if (this.eventWindow.isAncient(parentDescriptor)) {
            return null;
        }
        EventImpl candidateParent = this.parentHashMap.get(parentDescriptor.hash());
        if (candidateParent == null) {
            this.logsAndMetrics.childHasMissingParent(child, parentDescriptor);
            return null;
        }
        if (candidateParent.getBirthRound() != parentDescriptor.eventDescriptor().birthRound()) {
            this.logsAndMetrics.parentHasIncorrectBirthRound(child, parentDescriptor, candidateParent);
            return null;
        }
        Instant parentTimeCreated = candidateParent.getBaseEvent().getTimeCreated();
        Instant childTimeCreated = child.getTimeCreated();
        if (parentDescriptor.creator().equals((Object)child.getDescriptor().creator()) && parentTimeCreated.compareTo(childTimeCreated) >= 0) {
            this.logsAndMetrics.childTimeIsNotAfterSelfParentTime(child, candidateParent, parentTimeCreated, childTimeCreated);
            return null;
        }
        return candidateParent;
    }
}

