/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.eventhandling;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerPhase;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.metrics.RoundHandlingMetrics;
import com.swirlds.platform.metrics.TransactionMetrics;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public class DefaultTransactionHandler
implements TransactionHandler {
    private static final Logger logger = LogManager.getLogger(DefaultTransactionHandler.class);
    private final StateLifecycleManager stateLifecycleManager;
    private final RoundHandlingMetrics handlerMetrics;
    @NonNull
    private final NodeId selfId;
    @NonNull
    private final ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler;
    private boolean freezeRoundReceived = false;
    private Hash previousRoundLegacyRunningEventHash;
    private final StatusActionSubmitter statusActionSubmitter;
    private final SemanticVersion softwareVersion;
    private final int roundsNonAncient;
    private final PlatformContext platformContext;
    private final boolean writeLegacyRunningEventHash;
    private final boolean waitForPrehandle;
    private long accumulatedHashComplexity = 0L;
    private final TransactionMetrics transactionMetrics;

    public DefaultTransactionHandler(@NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager, @NonNull StatusActionSubmitter statusActionSubmitter, @NonNull SemanticVersion softwareVersion, @NonNull ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler, @NonNull NodeId selfId) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
        this.statusActionSubmitter = Objects.requireNonNull(statusActionSubmitter);
        this.softwareVersion = Objects.requireNonNull(softwareVersion);
        this.consensusStateEventHandler = Objects.requireNonNull(consensusStateEventHandler);
        this.selfId = Objects.requireNonNull(selfId);
        this.roundsNonAncient = ((ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class)).roundsNonAncient();
        this.handlerMetrics = new RoundHandlingMetrics(platformContext);
        this.transactionMetrics = new TransactionMetrics(platformContext.getMetrics());
        this.previousRoundLegacyRunningEventHash = Cryptography.NULL_HASH;
        PlatformSchedulersConfig schedulersConfig = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        this.writeLegacyRunningEventHash = schedulersConfig.consensusEventStream().type() != TaskSchedulerType.NO_OP;
        this.waitForPrehandle = schedulersConfig.applicationTransactionPrehandler().type() != TaskSchedulerType.NO_OP;
    }

    @Override
    public void updateLegacyRunningEventHash(@NonNull RunningEventHashOverride runningHashUpdate) {
        this.previousRoundLegacyRunningEventHash = runningHashUpdate.legacyRunningEventHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TransactionHandlerResult handleConsensusRound(@NonNull ConsensusRound consensusRound) {
        if (consensusRound.isEmpty()) {
            logger.info(LogMarker.STARTUP.getMarker(), "Ignoring empty consensus round {}", (Object)consensusRound.getRoundNum());
            return null;
        }
        if (this.freezeRoundReceived) {
            logger.info(LogMarker.STARTUP.getMarker(), "Round {} reached consensus after freeze. Round will not be processed until after network restarts.", (Object)consensusRound.getRoundNum());
            return null;
        }
        if (PlatformStateUtils.isInFreezePeriod(consensusRound.getConsensusTimestamp(), this.stateLifecycleManager.getMutableState())) {
            this.statusActionSubmitter.submitStatusAction(new FreezePeriodEnteredAction(consensusRound.getRoundNum()));
            this.freezeRoundReceived = true;
            logger.info(LogMarker.STARTUP.getMarker(), "Submitting freeze period entered action for consensus round: {} consensusTimeStamp: {} ", (Object)consensusRound.getRoundNum(), (Object)consensusRound.getConsensusTimestamp());
        }
        this.handlerMetrics.recordEventsPerRound(consensusRound.getNumEvents());
        this.handlerMetrics.recordConsensusTime(consensusRound.getConsensusTimestamp());
        try {
            this.handlerMetrics.setPhase(TransactionHandlerPhase.SETTING_EVENT_CONSENSUS_DATA);
            for (PlatformEvent event : consensusRound.getConsensusEvents()) {
                event.setConsensusTimestampsOnTransactions();
            }
            this.handlerMetrics.setPhase(TransactionHandlerPhase.UPDATING_PLATFORM_STATE);
            this.updatePlatformState(consensusRound);
            if (this.waitForPrehandle) {
                this.handlerMetrics.setPhase(TransactionHandlerPhase.WAITING_FOR_PREHANDLE);
                consensusRound.getConsensusEvents().forEach(PlatformEvent::awaitPrehandleCompletion);
            }
            this.handlerMetrics.setPhase(TransactionHandlerPhase.HANDLING_CONSENSUS_ROUND);
            Queue<ScopedSystemTransaction<StateSignatureTransaction>> systemTransactions = this.doHandleConsensusRound(consensusRound);
            this.handlerMetrics.setPhase(TransactionHandlerPhase.UPDATING_PLATFORM_STATE_RUNNING_HASH);
            this.updateRunningEventHash(consensusRound);
            TransactionHandlerResult transactionHandlerResult = this.createSignedState(consensusRound, systemTransactions);
            return transactionHandlerResult;
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "onHandleConsensusRound interrupted");
            Thread.currentThread().interrupt();
            TransactionHandlerResult transactionHandlerResult = null;
            return transactionHandlerResult;
        }
        finally {
            this.handlerMetrics.setPhase(TransactionHandlerPhase.IDLE);
        }
    }

    private Queue<ScopedSystemTransaction<StateSignatureTransaction>> doHandleConsensusRound(ConsensusRound round) {
        MerkleNodeState state = this.stateLifecycleManager.getMutableState();
        ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>> scopedSystemTransactions = new ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>>();
        try {
            Instant timeOfHandle = Instant.now();
            long startTime = System.nanoTime();
            this.consensusStateEventHandler.onHandleConsensusRound((Round)round, state, scopedSystemTransactions::add);
            double secondsElapsed = (double)(System.nanoTime() - startTime) * 1.0E-9;
            if (round.getNumAppTransactions() == 0) {
                this.transactionMetrics.consensusTransHandleTime(secondsElapsed);
            } else {
                this.transactionMetrics.consensusTransHandleTime(secondsElapsed / (double)round.getNumAppTransactions());
            }
            this.transactionMetrics.consensusTransHandled(round.getNumAppTransactions());
            this.transactionMetrics.consensusToHandleTime((double)round.getReachedConsTimestamp().until(timeOfHandle, ChronoUnit.NANOS) * 1.0E-9);
        }
        catch (Throwable t) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error invoking ConsensusStateEventHandler.onHandleConsensusRound() [ nodeId = {} ] with round {}", (Object)this.selfId, (Object)round.getRoundNum(), (Object)t);
        }
        return scopedSystemTransactions;
    }

    private void updatePlatformState(@NonNull ConsensusRound round) {
        PlatformStateUtils.bulkUpdateOf((State)this.stateLifecycleManager.getMutableState(), v -> {
            v.setRound(round.getRoundNum());
            v.setConsensusTimestamp(round.getConsensusTimestamp());
            v.setCreationSoftwareVersion(this.softwareVersion);
            v.setRoundsNonAncient(this.roundsNonAncient);
            v.setSnapshot(round.getSnapshot());
        });
    }

    private void updateRunningEventHash(@NonNull ConsensusRound round) throws InterruptedException {
        MerkleNodeState consensusState = this.stateLifecycleManager.getMutableState();
        if (this.writeLegacyRunningEventHash) {
            CesEvent last = (CesEvent)round.getStreamedEvents().getLast();
            if (this.freezeRoundReceived) {
                logger.info("Last event in the freezeRound {} has consensus time {} {}", (Object)round.getRoundNum(), (Object)last.getPlatformEvent().getConsensusTimestamp(), (Object)last.getPlatformEvent().getDescriptor());
            }
            if (!round.isEmpty()) {
                this.previousRoundLegacyRunningEventHash = (Hash)last.getRunningHash().getFutureHash().getAndRethrow();
            }
            PlatformStateUtils.setLegacyRunningEventHashTo((State)consensusState, this.previousRoundLegacyRunningEventHash);
        } else {
            PlatformStateUtils.setLegacyRunningEventHashTo((State)consensusState, Cryptography.NULL_HASH);
        }
    }

    @NonNull
    private TransactionHandlerResult createSignedState(@NonNull ConsensusRound consensusRound, @NonNull Queue<ScopedSystemTransaction<StateSignatureTransaction>> systemTransactions) throws InterruptedException {
        MerkleNodeState state;
        boolean isBoundary;
        if (this.freezeRoundReceived) {
            PlatformStateUtils.updateLastFrozenTime((State)this.stateLifecycleManager.getMutableState());
        }
        if ((isBoundary = this.consensusStateEventHandler.onSealConsensusRound((Round)consensusRound, state = this.stateLifecycleManager.getMutableState())) || this.freezeRoundReceived) {
            if (this.freezeRoundReceived && !isBoundary) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "The freeze round {} is not a boundary round. The freeze state will be saved to disk, but the app may not have done some work that it needs to (like finishing a block). The app must ensure that the freeze round is always a boundary round.", (Object)consensusRound.getRoundNum());
            }
            this.handlerMetrics.setPhase(TransactionHandlerPhase.GETTING_STATE_TO_SIGN);
            this.stateLifecycleManager.copyMutableState();
            MerkleNodeState immutableState = this.stateLifecycleManager.getLatestImmutableState();
            this.handlerMetrics.setPhase(TransactionHandlerPhase.CREATING_SIGNED_STATE);
            SignedState signedState = new SignedState(this.platformContext.getConfiguration(), CryptoStatic::verifySignature, immutableState, "TransactionHandler.createSignedState()", this.freezeRoundReceived, true, consensusRound.isPcesRound());
            ReservedSignedState reservedSignedState = signedState.reserve("transaction handler output");
            long hashComplexity = Math.max(this.accumulatedHashComplexity, 1L);
            TransactionHandlerResult result = new TransactionHandlerResult(new StateWithHashComplexity(reservedSignedState, hashComplexity), systemTransactions);
            this.accumulatedHashComplexity = 0L;
            return result;
        }
        this.accumulatedHashComplexity += (long)(consensusRound.getNumAppTransactions() - systemTransactions.size());
        return new TransactionHandlerResult(null, systemTransactions);
    }
}

