/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.platform.state.MerkleStateUtils;
import com.swirlds.platform.state.PlatformStateAccessor;
import com.swirlds.platform.state.PlatformStateModifier;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.platform.state.service.SnapshotPlatformStateAccessor;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.hashgraph.Round;

public final class PlatformStateUtils {
    public static boolean isFreezeRound(@NonNull State state, @NonNull Round round) {
        PlatformState platformState = PlatformStateUtils.platformStateOf(state);
        return PlatformStateUtils.isInFreezePeriod(round.getConsensusTimestamp(), platformState.freezeTime() == null ? null : HapiUtils.asInstant((Timestamp)platformState.freezeTime()), platformState.lastFrozenTime() == null ? null : HapiUtils.asInstant((Timestamp)platformState.lastFrozenTime()));
    }

    public static SemanticVersion creationSemanticVersionOf(@NonNull State state) {
        Objects.requireNonNull(state);
        PlatformState platformState = PlatformStateUtils.platformStateOf(state);
        return platformState == null ? null : platformState.creationSoftwareVersion();
    }

    public static boolean isGenesisStateOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getRound() == 0L;
    }

    public static boolean isInFreezePeriod(@NonNull Instant consensusTime, @NonNull MerkleNodeState state) {
        return PlatformStateUtils.isInFreezePeriod(consensusTime, PlatformStateUtils.freezeTimeOf((State)state), PlatformStateUtils.lastFrozenTimeOf((State)state));
    }

    public static boolean isInFreezePeriod(@NonNull Instant consensusTime, @Nullable Instant freezeTime, @Nullable Instant lastFrozenTime) {
        if (freezeTime == null || consensusTime.isBefore(freezeTime)) {
            return false;
        }
        return lastFrozenTime == null || lastFrozenTime.isBefore(freezeTime);
    }

    @Nullable
    public static SemanticVersion creationSoftwareVersionOf(@NonNull State state) {
        Objects.requireNonNull(state);
        if (PlatformStateUtils.isPlatformStateEmpty(state)) {
            return null;
        }
        return PlatformStateUtils.readablePlatformStateStore(state).getCreationSoftwareVersion();
    }

    private static boolean isPlatformStateEmpty(State state) {
        return state.getReadableStates("PlatformStateService").isEmpty();
    }

    public static long roundOf(@NonNull State root) {
        Objects.requireNonNull(root);
        return PlatformStateUtils.readablePlatformStateStore(root).getRound();
    }

    @Nullable
    public static PlatformState platformStateOf(@NonNull State state) {
        ReadableStates readableStates = state.getReadableStates("PlatformStateService");
        if (readableStates.isEmpty()) {
            return V0540PlatformStateSchema.UNINITIALIZED_PLATFORM_STATE;
        }
        return (PlatformState)readableStates.getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID).get();
    }

    @Nullable
    public static Hash legacyRunningEventHashOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getLegacyRunningEventHash();
    }

    public static long ancientThresholdOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getAncientThreshold();
    }

    @Nullable
    public static ConsensusSnapshot consensusSnapshotOf(@NonNull State root) {
        return PlatformStateUtils.readablePlatformStateStore(root).getSnapshot();
    }

    @Nullable
    public static Instant consensusTimestampOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getConsensusTimestamp();
    }

    public static Instant freezeTimeOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getFreezeTime();
    }

    public static void updateLastFrozenTime(@NonNull State state) {
        PlatformStateUtils.getWritablePlatformStateOf(state).setLastFrozenTime(PlatformStateUtils.freezeTimeOf(state));
    }

    @Nullable
    public static Instant lastFrozenTimeOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getLastFrozenTime();
    }

    public static long latestFreezeRoundOf(@NonNull State state) {
        return PlatformStateUtils.readablePlatformStateStore(state).getLatestFreezeRound();
    }

    @NonNull
    public static PlatformStateModifier getWritablePlatformStateOf(@NonNull State state) {
        if (state.isImmutable()) {
            throw new IllegalStateException("Cannot get writable platform state when state is immutable");
        }
        return PlatformStateUtils.writablePlatformStateStore(state);
    }

    public static void bulkUpdateOf(@NonNull State state, @NonNull Consumer<PlatformStateModifier> updater) {
        PlatformStateUtils.getWritablePlatformStateOf(state).bulkUpdate(updater);
    }

    public static void setSnapshotTo(@NonNull State state, @NonNull ConsensusSnapshot snapshot) {
        PlatformStateUtils.getWritablePlatformStateOf(state).setSnapshot(snapshot);
    }

    public static void setLegacyRunningEventHashTo(@NonNull State state, @Nullable Hash legacyRunningEventHash) {
        PlatformStateUtils.getWritablePlatformStateOf(state).setLegacyRunningEventHash(legacyRunningEventHash);
    }

    public static void setCreationSoftwareVersionTo(@NonNull State state, @NonNull SemanticVersion creationVersion) {
        PlatformStateUtils.getWritablePlatformStateOf(state).setCreationSoftwareVersion(creationVersion);
    }

    @NonNull
    public static String getInfoString(@NonNull State state, int hashDepth) {
        MerkleNodeState merkleNodeState = (MerkleNodeState)state;
        return MerkleStateUtils.createInfoString(hashDepth, PlatformStateUtils.readablePlatformStateStore(state), merkleNodeState.getHash(), merkleNodeState.getRoot()).concat(merkleNodeState.getInfoJson());
    }

    private static PlatformStateAccessor readablePlatformStateStore(@NonNull State state) {
        ReadableStates readableStates = state.getReadableStates("PlatformStateService");
        if (readableStates.isEmpty()) {
            return new SnapshotPlatformStateAccessor(V0540PlatformStateSchema.UNINITIALIZED_PLATFORM_STATE);
        }
        return new ReadablePlatformStateStore(readableStates);
    }

    private static WritablePlatformStateStore writablePlatformStateStore(@NonNull State state) {
        return new WritablePlatformStateStore(state.getWritableStates("PlatformStateService"));
    }

    private PlatformStateUtils() {
    }
}

