/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.stats;

import com.swirlds.common.metrics.StatEntry;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.stats.AtomicAverage;
import com.swirlds.platform.stats.AtomicMax;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class AverageAndMaxTimeStat {
    private static final String FORMAT_DEFAULT = "%,10.3f";
    private static final String FORMAT_SECONDS = "%,5.4f";
    private static final String FORMAT_MILLIS = "%,10.1f";
    private final ChronoUnit unit;
    private final AtomicAverage average;
    private final AtomicMax max;

    public AverageAndMaxTimeStat(Metrics metrics, ChronoUnit unit, String category, String name, String desc) {
        this(metrics, unit, category, name, desc, 0.01);
    }

    public AverageAndMaxTimeStat(Metrics metrics, ChronoUnit unit, String category, String name, String desc, double weight) {
        this.unit = unit;
        this.average = new AtomicAverage(weight);
        this.max = new AtomicMax();
        String format = switch (unit) {
            case ChronoUnit.MILLIS -> FORMAT_MILLIS;
            case ChronoUnit.SECONDS -> FORMAT_SECONDS;
            default -> FORMAT_DEFAULT;
        };
        metrics.getOrCreate((MetricConfig)new StatEntry.Config(category, name, Double.class, this::getAvg).withDescription(desc).withFormat(format).withReset(this::resetAvg));
        metrics.getOrCreate((MetricConfig)new StatEntry.Config(category, name + "MAX", Double.class, this::getMax).withDescription("max value of " + name).withFormat(format).withReset(this::resetMax).withResetStatsStringSupplier(this::getAndResetMax));
    }

    private double convert(long nanos) {
        return this.convert((double)nanos);
    }

    private double convert(double nanos) {
        return nanos / (double)this.unit.getDuration().toNanos();
    }

    private double getAvg() {
        return this.convert(this.average.get());
    }

    private void resetAvg(double unused) {
        this.average.reset();
    }

    private double getMax() {
        return this.convert(this.max.get());
    }

    private void resetMax(double unused) {
        this.max.reset();
    }

    private double getAndResetMax() {
        return this.convert(this.max.getAndReset());
    }

    public void update(long startTime) {
        this.update(startTime, System.nanoTime());
    }

    public void update(long start, long end) {
        this.updateInternal(end - start);
    }

    public void update(@NonNull Instant start) {
        this.updateInternal(Duration.between(start, Instant.now()).toNanos());
    }

    private void updateInternal(long nanos) {
        this.average.update(nanos);
        this.max.update(nanos);
    }
}

