/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class UnmodifiableArrayList<E>
extends ArrayList<E> {
    private boolean isReadOnly = false;

    public void makeReadOnly() {
        this.isReadOnly = true;
    }

    private void checkReadOnly() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException("This list is read-only");
        }
    }

    @Override
    public E set(int index, E element) {
        this.checkReadOnly();
        return super.set(index, element);
    }

    @Override
    public boolean add(E o) {
        this.checkReadOnly();
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.checkReadOnly();
        super.add(index, element);
    }

    @Override
    public void addFirst(E element) {
        this.checkReadOnly();
        super.addFirst(element);
    }

    @Override
    public void addLast(E element) {
        this.checkReadOnly();
        super.addLast(element);
    }

    @Override
    public E remove(int index) {
        this.checkReadOnly();
        return super.remove(index);
    }

    @Override
    public E removeFirst() {
        this.checkReadOnly();
        return super.removeFirst();
    }

    @Override
    public E removeLast() {
        this.checkReadOnly();
        return super.removeLast();
    }

    @Override
    public boolean remove(Object o) {
        this.checkReadOnly();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        super.clear();
    }

    @Override
    public boolean addAll(Collection c) {
        this.checkReadOnly();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        this.checkReadOnly();
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.checkReadOnly();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection c) {
        this.checkReadOnly();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.checkReadOnly();
        return super.retainAll(c);
    }

    @Override
    public boolean removeIf(Predicate filter) {
        this.checkReadOnly();
        return super.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator operator) {
        this.checkReadOnly();
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator c) {
        this.checkReadOnly();
        super.sort(c);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            private final ListIterator<E> i;
            {
                this.i = UnmodifiableArrayList.super.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public E previous() {
                return this.i.previous();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }

            @Override
            public void remove() {
                UnmodifiableArrayList.this.checkReadOnly();
                this.i.remove();
            }

            @Override
            public void set(E e) {
                UnmodifiableArrayList.this.checkReadOnly();
                this.i.set(e);
            }

            @Override
            public void add(E e) {
                UnmodifiableArrayList.this.checkReadOnly();
                this.i.add(e);
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.i.forEachRemaining(action);
            }
        };
    }
}

