/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.grpc;

import com.hedera.pbj.runtime.grpc.GrpcException;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Optional;

public interface ServiceInterface
extends AutoCloseable {
    @NonNull
    public String serviceName();

    @NonNull
    public String fullName();

    @NonNull
    public List<Method> methods();

    @NonNull
    public Pipeline<? super Bytes> open(@NonNull Method var1, @NonNull RequestOptions var2, @NonNull Pipeline<? super Bytes> var3) throws GrpcException;

    @Override
    default public void close() {
    }

    public static interface RequestOptions {
        public static final String APPLICATION_GRPC = "application/grpc";
        public static final String APPLICATION_GRPC_PROTO = "application/grpc+proto";
        public static final String APPLICATION_GRPC_JSON = "application/grpc+json";
        public static final int DEFAULT_MAX_MESSAGE_SIZE_BYTES = 10240;

        @NonNull
        public Optional<String> authority();

        default public boolean isProtobuf() {
            return APPLICATION_GRPC_PROTO.equals(this.contentType()) || APPLICATION_GRPC.equals(this.contentType());
        }

        default public boolean isJson() {
            return APPLICATION_GRPC_JSON.equals(this.contentType());
        }

        @NonNull
        public String contentType();

        default public int maxMessageSizeBytes() {
            return 10240;
        }
    }

    public static interface Method {
        public String name();
    }
}

