/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.freeze;

import com.swirlds.demo.platform.fs.stresstest.proto.FreezeTransaction;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.state.State;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FreezeTransactionHandler {
    private static final Logger logger = LogManager.getLogger(FreezeTransactionHandler.class);
    private static final Marker LOGM_FREEZE = MarkerManager.getMarker((String)"FREEZE");

    public static boolean freeze(FreezeTransaction transaction, State state) {
        logger.debug(LOGM_FREEZE, "Handling FreezeTransaction: " + String.valueOf(transaction));
        try {
            PlatformStateUtils.bulkUpdateOf((State)state, v -> v.setFreezeTime(Instant.ofEpochSecond(transaction.getStartTimeEpochSecond())));
            return true;
        }
        catch (IllegalArgumentException ex) {
            logger.warn(LOGM_FREEZE, "FreezeTransactionHandler::freeze fails. {}", (Object)ex.getMessage());
            return false;
        }
    }
}

