/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.FilteredMerkleSubTree;
import com.hedera.hapi.block.stream.SubMerkleTree;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class FilteredMerkleSubTreeJsonCodec
implements JsonCodec<FilteredMerkleSubTree> {
    @NonNull
    public FilteredMerkleSubTree parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_subtree_root_hash = Bytes.EMPTY;
            SubMerkleTree temp_tree = SubMerkleTree.fromProtobufOrdinal(0);
            int temp_filtered_leaf_count = 0;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "subtreeRootHash": {
                        temp_subtree_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"subtree_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "tree": {
                        temp_tree = SubMerkleTree.fromString(kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "filteredLeafCount": {
                        temp_filtered_leaf_count = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new FilteredMerkleSubTree(temp_subtree_root_hash, temp_tree, temp_filtered_leaf_count);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull FilteredMerkleSubTree data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.subtreeRootHash() != Bytes.EMPTY && data.subtreeRootHash() != null && data.subtreeRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"subtreeRootHash", (Bytes)data.subtreeRootHash()));
        }
        if (data.tree() != SubMerkleTree.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"tree", (String)data.tree().protoName()));
        }
        if (data.filteredLeafCount() != 0) {
            fieldLines.add(JsonTools.field((String)"filteredLeafCount", (int)data.filteredLeafCount()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

