/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hiero.base.Clearable;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class ConsensusOutput
implements Clearable {
    private final LinkedList<ConsensusRound> consensusRounds;
    private final LinkedList<PlatformEvent> preConsensusEvents;
    private final LinkedList<PlatformEvent> addedEvents = new LinkedList();
    private final LinkedList<PlatformEvent> staleEvents;
    private long latestRound;
    private EventWindow eventWindow;

    public ConsensusOutput() {
        this.preConsensusEvents = new LinkedList();
        this.consensusRounds = new LinkedList();
        this.staleEvents = new LinkedList();
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }

    public void eventAdded(@NonNull PlatformEvent event) {
        this.addedEvents.add(event);
    }

    public void consensusEngineOutput(@NonNull ConsensusEngineOutput output) {
        output.consensusRounds().forEach(this::consensusRound);
        this.preConsensusEvents.addAll(output.preConsensusEvents());
        this.staleEvents.addAll(output.staleEvents());
    }

    public void consensusRound(@NonNull ConsensusRound consensusRound) {
        this.consensusRounds.add(consensusRound);
        this.eventWindow = consensusRound.getEventWindow();
    }

    @NonNull
    public LinkedList<PlatformEvent> getStaleEvents() {
        return this.staleEvents;
    }

    @NonNull
    public Set<Hash> getStaleEventHashes() {
        return this.staleEvents.stream().map(PlatformEvent::getHash).collect(Collectors.toSet());
    }

    @NonNull
    public LinkedList<ConsensusRound> getConsensusRounds() {
        return this.consensusRounds;
    }

    @NonNull
    public ConsensusRound getLastConsensusRound() {
        return this.consensusRounds.getLast();
    }

    @NonNull
    public LinkedList<PlatformEvent> getAddedEvents() {
        return this.addedEvents;
    }

    @NonNull
    public List<PlatformEvent> sortedAddedEvents() {
        ArrayList<PlatformEvent> sortedEvents = new ArrayList<PlatformEvent>(this.addedEvents);
        sortedEvents.sort(Comparator.comparingLong(PlatformEvent::getBirthRound).thenComparingLong(e -> e.getCreatorId().id()).thenComparing(PlatformEvent::getHash));
        return sortedEvents;
    }

    @NonNull
    public List<PlatformEvent> getPreConsensusEvents() {
        return this.preConsensusEvents;
    }

    @NonNull
    public Set<Hash> getPreConsensusEventHashes() {
        return this.preConsensusEvents.stream().map(PlatformEvent::getHash).collect(Collectors.toSet());
    }

    @NonNull
    public Set<Hash> consensusEventHashes() {
        return this.consensusRounds.stream().map(ConsensusRound::getConsensusEvents).flatMap(Collection::stream).map(PlatformEvent::getHash).collect(Collectors.toSet());
    }

    @NonNull
    public List<PlatformEvent> getConsensusEvents() {
        return this.consensusRounds.stream().map(ConsensusRound::getConsensusEvents).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public long getLatestRound() {
        return this.latestRound;
    }

    @NonNull
    public EventWindow getEventWindow() {
        return this.eventWindow;
    }

    public void clear() {
        this.addedEvents.clear();
        this.consensusRounds.clear();
        this.staleEvents.clear();
        this.latestRound = 0L;
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }
}

