/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.emitter.AbstractEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public abstract class BufferingEventEmitter
extends AbstractEventEmitter {
    private static final int MAX_BUFFERED_EVENTS = 1000;
    protected Map<NodeId, Queue<EventImpl>> events;
    protected int bufferedEvents;
    protected long numEventsGenerated;

    protected BufferingEventEmitter(GraphGenerator graphGenerator) {
        super(graphGenerator);
        this.clearEvents();
    }

    protected void attemptToGenerateEventFromNode(@NonNull NodeId nodeID) {
        Objects.requireNonNull(nodeID, "nodeID");
        while (this.events.get(nodeID).isEmpty() && this.bufferedEvents < 1000 && this.getCheckpoint() > this.numEventsGenerated) {
            EventImpl nextEvent = this.getGraphGenerator().generateEvent();
            ++this.numEventsGenerated;
            this.events.get(nextEvent.getCreatorId()).add(nextEvent);
            ++this.bufferedEvents;
        }
    }

    protected void eventEmittedFromBuffer() {
        --this.bufferedEvents;
        ++this.numEventsEmitted;
    }

    protected void clearEvents() {
        Roster roster = this.getGraphGenerator().getRoster();
        this.events = new HashMap<NodeId, Queue<EventImpl>>(this.getGraphGenerator().getNumberOfSources());
        for (int index = 0; index < this.getGraphGenerator().getNumberOfSources(); ++index) {
            this.events.put(RosterUtils.getNodeId((Roster)roster, (int)index), new LinkedList());
        }
        this.bufferedEvents = 0;
    }

    protected boolean isReadyToEmitEvent(@NonNull NodeId nodeID) {
        Objects.requireNonNull(nodeID, "nodeID");
        EventImpl potentialEvent = this.events.get(nodeID).peek();
        if (potentialEvent == null) {
            return false;
        }
        EventImpl otherParent = (EventImpl)potentialEvent.getOtherParent();
        if (otherParent == null) {
            return true;
        }
        NodeId otherNodeID = otherParent.getCreatorId();
        for (EventImpl event : this.events.get(otherNodeID)) {
            if (event != otherParent) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.clearEvents();
        this.numEventsGenerated = 0L;
    }
}

