/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.simulated;

import com.swirlds.base.time.Time;
import com.swirlds.platform.test.fixtures.simulated.GossipMessage;
import com.swirlds.platform.test.fixtures.simulated.GossipMessageHandler;
import com.swirlds.platform.test.fixtures.simulated.NetworkLatency;
import com.swirlds.platform.test.fixtures.simulated.config.NetworkConfig;
import com.swirlds.platform.test.fixtures.simulated.config.NodeConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hiero.base.io.SelfSerializable;
import org.hiero.consensus.model.node.NodeId;

public class SimpleSimulatedGossip {
    private final Time time;
    private final Map<NodeId, GossipMessageHandler> nodes;
    private final Map<NodeId, Deque<Payload>> inTransit;
    private final Map<NodeId, Deque<GossipMessage>> delivered;
    private final Map<NodeId, Deque<GossipMessage>> sentBy;
    private final NetworkLatency latency;

    public SimpleSimulatedGossip(int numNodes, @NonNull NetworkLatency latency, @NonNull Time time) {
        this.latency = Objects.requireNonNull(latency);
        this.time = Objects.requireNonNull(time);
        this.nodes = new HashMap<NodeId, GossipMessageHandler>(numNodes);
        this.inTransit = new HashMap<NodeId, Deque<Payload>>(numNodes);
        this.delivered = new HashMap<NodeId, Deque<GossipMessage>>(numNodes);
        this.sentBy = new HashMap<NodeId, Deque<GossipMessage>>(numNodes);
    }

    public void setNode(@NonNull GossipMessageHandler node) {
        Objects.requireNonNull(node);
        this.nodes.put(node.getNodeId(), node);
        this.inTransit.put(node.getNodeId(), new ArrayDeque());
        this.delivered.put(node.getNodeId(), new ArrayDeque());
        this.sentBy.put(node.getNodeId(), new ArrayDeque());
    }

    public void gossipPayloads(@NonNull List<GossipMessage> messages) {
        Objects.requireNonNull(messages);
        messages.forEach(this::gossipPayload);
    }

    @NonNull
    public Deque<GossipMessage> getDeliveredTo(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId);
        return this.delivered.get(nodeId);
    }

    @NonNull
    public <T extends SelfSerializable> Deque<T> getDeliveredTo(@NonNull NodeId nodeId, @NonNull Class<T> clazz) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(clazz);
        return this.getDeliveredTo(nodeId).stream().filter(msg -> clazz.isAssignableFrom(msg.message().getClass())).map(msg -> msg.message()).collect(Collectors.toCollection(LinkedList::new));
    }

    @NonNull
    public Deque<GossipMessage> getSentBy(@NonNull NodeId nodeId) {
        return this.sentBy.get(nodeId);
    }

    @NonNull
    public <T extends SelfSerializable> Deque<T> getSentBy(@NonNull NodeId nodeId, @NonNull Class<T> clazz) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(clazz);
        return this.getSentBy(nodeId).stream().filter(msg -> clazz.isAssignableFrom(msg.message().getClass())).map(msg -> msg.message()).collect(Collectors.toCollection(LinkedList::new));
    }

    public void gossipPayload(@NonNull GossipMessage message) {
        Objects.requireNonNull(message);
        this.sentBy.get(message.senderId()).add(message);
        if (message.recipientId() == null) {
            this.sendToAllPeers(message);
        } else {
            this.sendToPeer(message);
        }
    }

    private void sendToPeer(@NonNull GossipMessage message) {
        NodeId recipient = message.recipientId();
        Duration delay = this.latency.getLatency(message.senderId(), recipient);
        this.inTransit.get(recipient).add(new Payload(message, this.time.now().plus(delay)));
    }

    private void sendToAllPeers(@NonNull GossipMessage message) {
        Objects.requireNonNull(message);
        for (NodeId nodeId : this.nodes.keySet()) {
            if (nodeId == message.senderId()) continue;
            Duration delay = this.latency.getLatency(message.senderId(), nodeId);
            this.inTransit.get(nodeId).add(new Payload(message, this.time.now().plus(delay)));
        }
    }

    public void distribute() {
        for (Map.Entry<NodeId, Deque<Payload>> entry : this.inTransit.entrySet()) {
            Deque<Payload> queue = entry.getValue();
            NodeId nodeId = entry.getKey();
            Iterator<Payload> iterator = queue.iterator();
            while (iterator.hasNext()) {
                Payload payload = iterator.next();
                if (this.time.now().isBefore(payload.arrivalTime())) continue;
                this.nodes.get(nodeId).handleMessageFromWire(payload.gossipMessage().message(), payload.gossipMessage.senderId());
                this.delivered.get(nodeId).add(payload.gossipMessage);
                iterator.remove();
            }
        }
    }

    public void applyConfig(@NonNull NetworkConfig networkConfig) {
        for (Map.Entry<NodeId, NodeConfig> entry : networkConfig.nodeConfigs().entrySet()) {
            NodeId nodeId = entry.getKey();
            NodeConfig nodeConfig = entry.getValue();
            if (nodeConfig.customLatency().isZero()) continue;
            this.latency.setLatency(nodeId, nodeConfig.customLatency());
        }
    }

    public void printQueues() {
        StringBuilder sb = new StringBuilder();
        this.printInTransit(sb);
        this.printDelivered(sb);
        System.out.println(sb);
    }

    private void printSentBy(@NonNull StringBuilder sb) {
        for (Map.Entry<NodeId, Deque<GossipMessage>> entry : this.sentBy.entrySet()) {
            Deque<GossipMessage> queue = entry.getValue();
            sb.append(String.format("Messages sent by %s (%s messages)%n", entry.getKey(), queue.size()));
            for (GossipMessage msg : queue) {
                sb.append("\t").append(msg).append("\n");
            }
            sb.append("\n");
        }
    }

    private void printDelivered(@NonNull StringBuilder sb) {
        for (Map.Entry<NodeId, Deque<GossipMessage>> entry : this.delivered.entrySet()) {
            Deque<GossipMessage> queue = entry.getValue();
            sb.append(String.format("Messages delivered to %s (%s messages)%n", entry.getKey(), queue.size()));
            for (GossipMessage msg : queue) {
                sb.append("\t").append(msg).append("\n");
            }
            sb.append("\n");
        }
    }

    private void printInTransit(@NonNull StringBuilder sb) {
        for (Map.Entry<NodeId, Deque<Payload>> entry : this.inTransit.entrySet()) {
            Deque<Payload> queue = entry.getValue();
            sb.append(String.format("Messages in transit to %s (%s messages)%n", entry.getKey(), queue.size()));
            for (Payload payload : queue) {
                sb.append("\t").append(payload).append("\n");
            }
            sb.append("\n");
        }
    }

    public record Payload(@NonNull GossipMessage gossipMessage, @NonNull Instant arrivalTime) {
        @Override
        public String toString() {
            return this.gossipMessage.toString();
        }
    }
}

