/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.views;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.task.LearnerPushTask;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.constructable.ClassIdFormatter;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;

public class LearnerPushMerkleTreeView
implements LearnerTreeView<MerkleNode> {
    private final ReconnectConfig reconnectConfig;
    private final MerkleNode originalRoot;
    private AsyncInputStream<Lesson<MerkleNode>> in;
    private AsyncOutputStream<QueryResponse> out;
    private final Queue<ExpectedLesson<MerkleNode>> expectedLessons;
    private final LinkedList<MerkleInternal> nodesToInitialize;
    private final ReconnectMapStats mapStats;

    public LearnerPushMerkleTreeView(ReconnectConfig reconnectConfig, MerkleNode root, @NonNull ReconnectMapStats mapStats) {
        this.reconnectConfig = reconnectConfig;
        this.originalRoot = root;
        this.mapStats = mapStats;
        this.expectedLessons = new LinkedList<ExpectedLesson<MerkleNode>>();
        this.nodesToInitialize = new LinkedList();
    }

    @Override
    public void startLearnerTasks(LearningSynchronizer learningSynchronizer, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream, Queue<MerkleNode> rootsToReceive, AtomicReference<MerkleNode> reconstructedRoot) {
        this.in = new AsyncInputStream<Lesson>(inputStream, workGroup, () -> new Lesson<MerkleNode>(this), this.reconnectConfig);
        this.out = learningSynchronizer.buildOutputStream(workGroup, outputStream);
        this.in.start();
        this.out.start();
        LearnerPushTask<MerkleNode> learnerThread = new LearnerPushTask<MerkleNode>(workGroup, this.in, this.out, rootsToReceive, reconstructedRoot, this, learningSynchronizer, this.mapStats);
        learnerThread.start();
    }

    @Override
    public void abort() {
        this.in.abort();
    }

    @Override
    public boolean isRootOfState() {
        return true;
    }

    @Override
    public MerkleNode getOriginalRoot() {
        return this.originalRoot;
    }

    @Override
    public boolean isInternal(MerkleNode node, boolean isOriginal) {
        return node != null && !node.isLeaf();
    }

    @Override
    public int getNumberOfChildren(MerkleNode node) {
        if (node == null || node.isLeaf()) {
            throw new MerkleSynchronizationException("only internal nodes have a child count");
        }
        return node.asInternal().getNumberOfChildren();
    }

    @Override
    public Hash getNodeHash(MerkleNode node) {
        if (node == null) {
            return Cryptography.NULL_HASH;
        }
        return node.getHash();
    }

    @Override
    public long getClassId(MerkleNode node) {
        if (node == null) {
            throw new MerkleSynchronizationException("null does not have a class ID");
        }
        return node.getClassId();
    }

    @Override
    public MerkleNode convertMerkleRootToViewType(MerkleNode node) {
        return node;
    }

    @Override
    public MerkleNode getMerkleRoot(MerkleNode node) {
        return node;
    }

    @Override
    public MerkleNode getChild(MerkleNode parent, int childIndex) {
        if (parent == null || parent.isLeaf()) {
            throw new MerkleSynchronizationException("can not get child of leaf node");
        }
        return parent.asInternal().getChild(childIndex);
    }

    @Override
    public void setChild(MerkleNode parent, int childIndex, MerkleNode child) {
        parent.asInternal().setChild(childIndex, child);
    }

    @Override
    public void expectLessonFor(MerkleNode parent, int childIndex, MerkleNode original, boolean nodeAlreadyPresent) {
        this.expectedLessons.add(new ExpectedLesson<MerkleNode>(parent, childIndex, original, nodeAlreadyPresent));
    }

    @Override
    public ExpectedLesson<MerkleNode> getNextExpectedLesson() {
        return this.expectedLessons.remove();
    }

    @Override
    public boolean hasNextExpectedLesson() {
        return !this.expectedLessons.isEmpty();
    }

    @Override
    public MerkleNode deserializeLeaf(SerializableDataInputStream in) throws IOException {
        return (MerkleNode)in.readSerializable();
    }

    @Override
    public MerkleNode deserializeInternal(SerializableDataInputStream in) throws IOException {
        long classId = in.readLong();
        MerkleInternal internal = (MerkleInternal)ConstructableRegistry.getInstance().createObject(classId);
        if (internal == null) {
            throw new MerkleSynchronizationException("unable to construct object with class ID " + ClassIdFormatter.classIdString((long)classId));
        }
        return internal;
    }

    @Override
    public void markForInitialization(MerkleNode node) {
        this.nodesToInitialize.add(node.asInternal());
    }

    @Override
    public void initialize() {
        Iterator<MerkleInternal> iterator = this.nodesToInitialize.descendingIterator();
        while (iterator.hasNext()) {
            iterator.next().rebuild();
        }
    }

    @Override
    public void releaseNode(MerkleNode node) {
        if (node != null) {
            node.release();
        }
    }

    @Override
    public void recordHashStats(@NonNull ReconnectMapStats mapStats, @NonNull MerkleNode parent, int childIndex, boolean nodeAlreadyPresent) {
        if (!parent.isInternal()) {
            throw new IllegalArgumentException("parent is not an internal node: " + String.valueOf(parent));
        }
        MerkleNode child = parent.asInternal().getChild(childIndex);
        if (child == null) {
            return;
        }
        if (child.isLeaf()) {
            mapStats.incrementLeafHashes(1, nodeAlreadyPresent ? 1 : 0);
        } else {
            mapStats.incrementInternalHashes(1, nodeAlreadyPresent ? 1 : 0);
        }
    }
}

