/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.PlatformMetricConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Deprecated(forRemoval=true)
public interface StatEntry
extends Metric {
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.STAT_ENTRY;
    }

    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return this.getBuffered() == null ? EnumSet.of(Metric.ValueType.VALUE) : EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @NonNull
    default public Object get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (this.getBuffered() == null) {
            if (valueType == Metric.ValueType.VALUE) {
                return this.getStatsStringSupplier().get();
            }
            throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf(valueType));
        }
        return switch (valueType) {
            case Metric.ValueType.VALUE -> this.getStatsStringSupplier().get();
            case Metric.ValueType.MAX -> this.getBuffered().getMax();
            case Metric.ValueType.MIN -> this.getBuffered().getMin();
            case Metric.ValueType.STD_DEV -> this.getBuffered().getStdDev();
            default -> throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf(valueType));
        };
    }

    @Nullable
    public StatsBuffered getBuffered();

    @Nullable
    public Consumer<Double> getReset();

    @NonNull
    public Supplier<Object> getStatsStringSupplier();

    @NonNull
    public Supplier<Object> getResetStatsStringSupplier();

    public static final class Config<T>
    extends PlatformMetricConfig<StatEntry, Config<T>> {
        @NonNull
        private final Class<T> type;
        @Nullable
        private final StatsBuffered buffered;
        @Nullable
        private final Function<Double, StatsBuffered> init;
        @Nullable
        private final Consumer<Double> reset;
        @NonNull
        private final Supplier<T> statsStringSupplier;
        @NonNull
        private final Supplier<T> resetStatsStringSupplier;
        private final double halfLife;

        public Config(@NonNull String category, @NonNull String name, @NonNull Class<T> type, @NonNull Supplier<T> statsStringSupplier) {
            super(category, name, "%,11.3f");
            this.type = Objects.requireNonNull(type, "type must not be null");
            this.buffered = null;
            this.init = null;
            this.reset = null;
            this.statsStringSupplier = Objects.requireNonNull(statsStringSupplier, "statsStringSupplier must not be null");
            this.resetStatsStringSupplier = statsStringSupplier;
            this.halfLife = -1.0;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, @NonNull Class<T> type, @Nullable StatsBuffered buffered, @Nullable Function<Double, StatsBuffered> init, @Nullable Consumer<Double> reset, @NonNull Supplier<T> statsStringSupplier, @NonNull Supplier<T> resetStatsStringSupplier, double halfLife) {
            super(category, name, description, unit, format);
            this.type = Objects.requireNonNull(type, "type must not be null");
            this.buffered = buffered;
            this.init = init;
            this.reset = reset;
            this.statsStringSupplier = Objects.requireNonNull(statsStringSupplier, "statsStringSupplier must not be null");
            this.resetStatsStringSupplier = Objects.requireNonNull(resetStatsStringSupplier, "resetStatsStringSupplier must not be null");
            this.halfLife = halfLife;
        }

        @NonNull
        public Config<T> withDescription(@NonNull String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @NonNull
        public Config<T> withUnit(@NonNull String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @NonNull
        public Config<T> withFormat(@NonNull String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @NonNull
        public Class<T> getType() {
            return this.type;
        }

        @Nullable
        public StatsBuffered getBuffered() {
            return this.buffered;
        }

        @NonNull
        public Config<T> withBuffered(@Nullable StatsBuffered buffered) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), buffered, this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @Nullable
        public Function<Double, StatsBuffered> getInit() {
            return this.init;
        }

        @NonNull
        public Config<T> withInit(@Nullable Function<Double, StatsBuffered> init) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), init, this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @Nullable
        public Consumer<Double> getReset() {
            return this.reset;
        }

        @NonNull
        public Config<T> withReset(@Nullable Consumer<Double> reset) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), reset, this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @NonNull
        public Supplier<T> getStatsStringSupplier() {
            return this.statsStringSupplier;
        }

        @NonNull
        public Supplier<T> getResetStatsStringSupplier() {
            return this.resetStatsStringSupplier;
        }

        @NonNull
        public Config<T> withResetStatsStringSupplier(@NonNull Supplier<T> resetStatsStringSupplier) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), resetStatsStringSupplier, this.getHalfLife());
        }

        @NonNull
        public Class<StatEntry> getResultClass() {
            return StatEntry.class;
        }

        @NonNull
        public Config<T> withHalfLife(double halfLife) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), halfLife);
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        @Override
        @NonNull
        public StatEntry create(@NonNull PlatformMetricsFactory factory) {
            return factory.createStatEntry(this);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

