/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.time.Time;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.platform.AbstractDistributionMetric;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.common.metrics.statistics.StatsRunningAverage;
import edu.umd.cs.findbugs.annotations.NonNull;

public class PlatformRunningAverageMetric
extends AbstractDistributionMetric
implements RunningAverageMetric {
    @NonNull
    private final StatsRunningAverage runningAverage;

    public PlatformRunningAverageMetric(@NonNull RunningAverageMetric.Config config) {
        this(config, Time.getCurrent());
    }

    public PlatformRunningAverageMetric(RunningAverageMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.runningAverage = new StatsRunningAverage(this.halfLife, time);
    }

    @Override
    @NonNull
    public StatsBuffered getStatsBuffered() {
        return this.runningAverage;
    }

    @Override
    public void update(double value) {
        this.runningAverage.recordValue(value);
    }

    @Override
    public double get() {
        return this.runningAverage.getWeightedMean();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).append("value", (Object)this.get()).toString();
    }
}

