/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.AppStartParams;
import com.swirlds.platform.ApplicationDefinition;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.config.legacy.ConfigurationException;
import com.swirlds.platform.config.legacy.JarAppConfig;
import com.swirlds.platform.config.legacy.LegacyConfigProperties;
import com.swirlds.platform.config.legacy.LegacyConfigPropertiesLoader;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.roster.AddressBook;

@Deprecated(forRemoval=true)
public final class ApplicationDefinitionLoader {
    private static final Logger logger = LogManager.getLogger(ApplicationDefinitionLoader.class);

    private ApplicationDefinitionLoader() {
    }

    @NonNull
    public static ApplicationDefinition loadDefault(@NonNull PathsConfig pathsConfig, @NonNull Path configPath) throws ConfigurationException {
        return ApplicationDefinitionLoader.load(pathsConfig, LegacyConfigPropertiesLoader.loadConfigFile(configPath));
    }

    @NonNull
    public static ApplicationDefinition load(@NonNull PathsConfig pathsConfig, @NonNull LegacyConfigProperties configurationProperties) throws ConfigurationException {
        Objects.requireNonNull(configurationProperties, "configurationProperties must not be null");
        String swirldName = configurationProperties.swirldName().orElse("");
        AddressBook addressBook = configurationProperties.getAddressBook();
        AppStartParams appStartParams = configurationProperties.appConfig().map(p -> ApplicationDefinitionLoader.convertToStartParams(pathsConfig, p)).orElseThrow(() -> new ConfigurationException("application config is missing"));
        return new ApplicationDefinition(swirldName, appStartParams.appParameters(), appStartParams.mainClassname(), appStartParams.appJarPath(), addressBook);
    }

    @NonNull
    private static AppStartParams convertToStartParams(@NonNull PathsConfig pathsConfig, @NonNull JarAppConfig appConfig) {
        String[] appParameters = appConfig.params();
        String appJarFilename = appConfig.jarName();
        Path appJarPath = pathsConfig.getAppsDirPath().resolve(appJarFilename);
        String mainClassname = "";
        try (JarFile jarFile = new JarFile(appJarPath.toFile());){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            mainClassname = attributes.getValue("Main-Class");
        }
        catch (Exception e) {
            CommonUtils.tellUserConsolePopup((String)"ERROR", (String)("ERROR: Couldn't load app " + String.valueOf(appJarPath)));
            logger.error(LogMarker.EXCEPTION.getMarker(), "Couldn't find Main-Class name in jar file {}", (Object)appJarPath, (Object)e);
        }
        return new AppStartParams(appParameters, appJarFilename, mainClassname, appJarPath);
    }
}

