/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileTracker;
import com.swirlds.platform.event.preconsensus.PcesUtilities;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.ValueReference;

public class PcesFileReader {
    private static final Logger logger = LogManager.getLogger(PcesFileReader.class);

    private PcesFileReader() {
    }

    public static PcesFileTracker readFilesFromDisk(@NonNull Configuration configuration, @NonNull RecycleBin recycleBin, @NonNull Path databaseDirectory, long startingRound, boolean permitGaps) throws IOException {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(recycleBin);
        Objects.requireNonNull(databaseDirectory);
        PcesConfig pcesConfig = (PcesConfig)configuration.getConfigData(PcesConfig.class);
        boolean doInitialSpanCompaction = pcesConfig.compactLastFileOnStartup();
        PcesFileTracker files = new PcesFileTracker();
        try (Stream<Path> fileStream = Files.walk(databaseDirectory, new FileVisitOption[0]);){
            fileStream.filter(f -> !Files.isDirectory(f, new LinkOption[0])).map(PcesUtilities::parseFile).filter(Objects::nonNull).sorted().forEachOrdered(PcesFileReader.buildFileHandler(files, permitGaps));
        }
        if (files.getFileCount() != 0 && doInitialSpanCompaction) {
            PcesFileReader.compactSpanOfLastFile(files);
        }
        PcesFileReader.resolveDiscontinuities(databaseDirectory, files, recycleBin, startingRound);
        return files;
    }

    private static void compactSpanOfLastFile(@NonNull PcesFileTracker files) {
        long previousMaximumBound;
        Objects.requireNonNull(files);
        PcesFile lastFile = files.getFile(files.getFileCount() - 1);
        if (files.getFileCount() > 1) {
            PcesFile secondToLastFile = files.getFile(files.getFileCount() - 2);
            previousMaximumBound = secondToLastFile.getUpperBound();
        } else {
            previousMaximumBound = 0L;
        }
        PcesFile compactedFile = PcesUtilities.compactPreconsensusEventFile(lastFile, previousMaximumBound);
        files.setFile(files.getFileCount() - 1, compactedFile);
    }

    @NonNull
    private static Consumer<PcesFile> buildFileHandler(@NonNull PcesFileTracker files, boolean permitGaps) {
        ValueReference previousSequenceNumber = new ValueReference((Object)-1L);
        ValueReference previousMinimumBound = new ValueReference((Object)-1L);
        ValueReference previousMaximumBound = new ValueReference((Object)-1L);
        ValueReference previousOrigin = new ValueReference((Object)-1L);
        ValueReference previousTimestamp = new ValueReference();
        return descriptor -> {
            if ((Long)previousSequenceNumber.getValue() != -1L) {
                PcesUtilities.fileSanityChecks(permitGaps, (Long)previousSequenceNumber.getValue(), (Long)previousMinimumBound.getValue(), (Long)previousMaximumBound.getValue(), (Long)previousOrigin.getValue(), (Instant)previousTimestamp.getValue(), descriptor);
            }
            previousSequenceNumber.setValue((Object)descriptor.getSequenceNumber());
            previousMinimumBound.setValue((Object)descriptor.getLowerBound());
            previousMaximumBound.setValue((Object)descriptor.getUpperBound());
            previousTimestamp.setValue((Object)descriptor.getTimestamp());
            files.addFile((PcesFile)descriptor);
        };
    }

    private static void resolveDiscontinuities(@NonNull Path databaseDirectory, @NonNull PcesFileTracker files, @NonNull RecycleBin recycleBin, long startingRound) throws IOException {
        PcesFile file;
        int firstIndexToDelete;
        long initialOrigin = PcesUtilities.getInitialOrigin(files, startingRound);
        int firstRelevantFileIndex = files.getFirstRelevantFileIndex(initialOrigin);
        for (firstIndexToDelete = firstRelevantFileIndex + 1; firstIndexToDelete < files.getFileCount() && (file = files.getFile(firstIndexToDelete)).getOrigin() == initialOrigin; ++firstIndexToDelete) {
        }
        if (firstIndexToDelete == files.getFileCount()) {
            return;
        }
        PcesFile lastUndeletedFile = firstIndexToDelete > 0 ? files.getFile(firstIndexToDelete - 1) : null;
        logger.warn(LogMarker.STARTUP.getMarker(), "Discontinuity detected in the preconsensus event stream. Purging {} file(s).\n    Last undeleted file: {}\n    First deleted file:  {}\n    Last deleted file:   {}", (Object)(files.getFileCount() - firstIndexToDelete), (Object)lastUndeletedFile, (Object)files.getFile(firstIndexToDelete), (Object)files.getLastFile());
        while (files.getFileCount() > firstIndexToDelete) {
            files.removeLastFile().deleteFile(databaseDirectory, recycleBin);
        }
    }
}

