/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.common.utility.throttle.RateLimiter;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.gossip.shadowgraph.SyncTimeoutException;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.connectivity.SocketFactory;
import com.swirlds.platform.network.connectivity.TlsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.hiero.consensus.exceptions.PlatformConstructionException;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public final class NetworkUtils {
    private static final Logger logger = LogManager.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
    }

    public static void handleNetworkException(Exception e, Connection connection, RateLimiter socketExceptionRateLimiter) throws InterruptedException {
        String description;
        if (connection != null) {
            connection.disconnect();
            description = connection.getDescription();
        } else {
            description = null;
        }
        if (e instanceof InterruptedException) {
            InterruptedException ie = (InterruptedException)e;
            throw ie;
        }
        Marker marker = NetworkUtils.determineExceptionMarker(e);
        if (LogMarker.SOCKET_EXCEPTIONS.getMarker().equals((Object)marker)) {
            if (socketExceptionRateLimiter.requestAndTrigger()) {
                logger.warn(marker, "Connection broken: {}", (Object)description, (Object)e);
            } else {
                String formattedException = NetworkUtils.formatException(e);
                logger.warn(marker, "Connection broken: {} {}", (Object)description, (Object)formattedException);
            }
        } else {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Connection broken: {}", (Object)description, (Object)e);
        }
    }

    public static Marker determineExceptionMarker(Exception e) {
        return Utilities.isCausedByIOException(e) || Utilities.isRootCauseSuppliedType(e, SyncTimeoutException.class) || Utilities.hasAnyCauseSuppliedType(e, SSLException.class) ? LogMarker.SOCKET_EXCEPTIONS.getMarker() : LogMarker.EXCEPTION.getMarker();
    }

    public static String formatException(Throwable e) {
        if (e == null) {
            return "";
        }
        return "Caused by exception: " + e.getClass().getSimpleName() + " Message: " + e.getMessage() + " " + NetworkUtils.formatException(e.getCause());
    }

    @NonNull
    public static SocketFactory createSocketFactory(@NonNull NodeId selfId, @NonNull List<PeerInfo> peers, @NonNull KeysAndCerts ownKeysAndCerts, @NonNull Configuration configuration) {
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(peers);
        Objects.requireNonNull(ownKeysAndCerts);
        Objects.requireNonNull(configuration);
        try {
            return new TlsFactory(ownKeysAndCerts.agrCert(), ownKeysAndCerts.agrKeyPair().getPrivate(), peers, selfId, configuration);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new PlatformConstructionException("A problem occurred while creating the SocketFactory", (Throwable)e);
        }
    }
}

