/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.connectivity;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.config.GossipConfig;
import com.swirlds.platform.gossip.config.NetworkEndpoint;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.SocketConfig;
import com.swirlds.platform.network.SocketConnection;
import com.swirlds.platform.network.connection.NotConnectedConnection;
import com.swirlds.platform.network.connectivity.SocketFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterEntryNotFoundException;

public class OutboundConnectionCreator {
    private static final Logger logger = LogManager.getLogger(OutboundConnectionCreator.class);
    private static final String LOCALHOST = "127.0.0.1";
    private final NodeId selfId;
    private final SocketConfig socketConfig;
    private final GossipConfig gossipConfig;
    private final ConnectionTracker connectionTracker;
    private final SocketFactory socketFactory;
    private final PlatformContext platformContext;
    private final Map<NodeId, PeerInfo> peers = new HashMap<NodeId, PeerInfo>();

    public OutboundConnectionCreator(@NonNull PlatformContext platformContext, @NonNull NodeId selfId, @NonNull ConnectionTracker connectionTracker, @NonNull SocketFactory socketFactory, @NonNull List<PeerInfo> peers) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.selfId = Objects.requireNonNull(selfId);
        this.connectionTracker = Objects.requireNonNull(connectionTracker);
        this.socketFactory = Objects.requireNonNull(socketFactory);
        this.peers.putAll(peers.stream().collect(Collectors.toMap(PeerInfo::nodeId, Function.identity())));
        this.socketConfig = (SocketConfig)platformContext.getConfiguration().getConfigData(SocketConfig.class);
        this.gossipConfig = (GossipConfig)platformContext.getConfiguration().getConfigData(GossipConfig.class);
    }

    public Connection createConnection(NodeId otherId) {
        PeerInfo other = this.peers.get(otherId);
        if (other == null) {
            throw new RosterEntryNotFoundException("No RosterEntry with nodeId: " + String.valueOf(otherId) + " in peer list: " + String.valueOf(this.peers.keySet()));
        }
        NetworkEndpoint networkEndpoint = this.gossipConfig.getEndpointOverride(otherId.id()).orElseGet(() -> {
            try {
                return new NetworkEndpoint(otherId.id(), InetAddress.getByName(other.hostname()), other.port());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Host '" + other.hostname() + "' not found", e);
            }
        });
        Socket clientSocket = null;
        SyncOutputStream dos = null;
        SyncInputStream dis = null;
        try {
            clientSocket = this.socketFactory.createClientSocket(networkEndpoint.hostname().getHostAddress(), networkEndpoint.port());
            dos = SyncOutputStream.createSyncOutputStream(this.platformContext, clientSocket.getOutputStream(), this.socketConfig.bufferSize());
            dis = SyncInputStream.createSyncInputStream(this.platformContext, clientSocket.getInputStream(), this.socketConfig.bufferSize());
            logger.debug(LogMarker.NETWORK.getMarker(), "`connect` : finished, {} connected to {}", (Object)this.selfId, (Object)otherId);
            return SocketConnection.create(this.selfId, otherId, this.connectionTracker, true, clientSocket, dis, dos, this.platformContext.getConfiguration());
        }
        catch (SocketException | SocketTimeoutException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            logger.debug(LogMarker.TCP_CONNECT_EXCEPTIONS.getMarker(), "{} failed to connect to {} with error:", (Object)this.selfId, (Object)otherId, (Object)e);
        }
        catch (IOException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            String formattedException = NetworkUtils.formatException(e);
            logger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "{} failed to connect to {} {}", (Object)this.selfId, (Object)otherId, (Object)formattedException);
        }
        catch (RuntimeException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            logger.debug(LogMarker.EXCEPTION.getMarker(), "{} failed to connect to {}", (Object)this.selfId, (Object)otherId, (Object)e);
        }
        return NotConnectedConnection.getSingleton();
    }
}

