/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.common.merkle.utility.MerkleUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.signed.ReservedSignedState;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="rehash", mixinStandardHelpOptions=true, description={"Recompute the hash for the state."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorRehash
extends StateEditorOperation {
    @Override
    public void run() {
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorRehash.run()");){
            Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
            MerkleCryptography merkleCryptography = MerkleCryptographyFactory.create((Configuration)configuration);
            MerkleUtils.rehashTree((MerkleCryptography)merkleCryptography, (MerkleNode)reservedSignedState.get().getState().getRoot());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

