/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.io.internal;

import com.swirlds.base.test.fixtures.io.SystemErrProvider;
import com.swirlds.base.test.fixtures.io.internal.SystemIoProvider;
import com.swirlds.base.test.fixtures.util.TestInjector;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class SystemErrorExtension
implements InvocationInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptTestMethod(@NonNull InvocationInterceptor.Invocation<Void> invocation, @NonNull ReflectiveInvocationContext<Method> invocationContext, @NonNull ExtensionContext extensionContext) throws Throwable {
        Objects.requireNonNull(invocation, "invocation must not be null");
        Objects.requireNonNull(extensionContext, "extensionContext must not be null");
        PrintStream originalSystemErrorPrintStream = System.err;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            SystemIoProvider provider = new SystemIoProvider(byteArrayOutputStream);
            System.setErr(new PrintStream(byteArrayOutputStream));
            TestInjector.injectInTest(SystemErrProvider.class, () -> provider, extensionContext);
            invocation.proceed();
        }
        finally {
            System.setErr(originalSystemErrorPrintStream);
        }
    }
}

