/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility.test.fixtures.io;

import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SelfSerializableExample
implements SelfSerializable {
    private static final long CLASS_ID = 1548074968037358709L;
    private int CLASS_VERSION = 1;
    private static final int STRING_MAX_BYTES = 512;
    private int aNumber;
    private String aString;

    public SelfSerializableExample() {
    }

    public SelfSerializableExample(int aNumber, String aString) {
        this.aNumber = aNumber;
        this.aString = aString;
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.aNumber = in.readInt();
        this.aString = in.readNormalisedString(512);
    }

    public long getClassId() {
        return 1548074968037358709L;
    }

    public int getVersion() {
        return this.CLASS_VERSION;
    }

    public void setVersion(int CLASS_VERSION) {
        this.CLASS_VERSION = CLASS_VERSION;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.aNumber);
        out.writeNormalisedString(this.aString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfSerializableExample that = (SelfSerializableExample)o;
        return this.aNumber == that.aNumber && Objects.equals(this.aString, that.aString);
    }

    public String toString() {
        return "SerializableDetExample{aNumber=" + this.aNumber + ", aString='" + this.aString + "'}";
    }
}

