/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.test.fixtures.TestBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;

public class TestArgumentUtils {
    private static final Random RAND = new Random(8892381L);

    public static Stream<Arguments> illegalIdentifiers() {
        ArrayList<Object> illegalChars = new ArrayList<Object>();
        for (char i = '\u0000'; i < '\u00ff'; i = (char)((char)(i + 1))) {
            if (i >= 'A' && i <= 'Z' || i >= 'a' && i <= 'z' || i >= '0' && i <= '9' || i == '-' || i == '_') continue;
            illegalChars.add("" + i);
        }
        illegalChars.add("\ud83d\ude08");
        LinkedList<Arguments> argumentsList = new LinkedList<Arguments>();
        for (String string : illegalChars) {
            argumentsList.add(Arguments.of((Object[])new Object[]{string}));
        }
        for (String string : illegalChars) {
            argumentsList.add(Arguments.of((Object[])new Object[]{"Some Legal Characters " + string}));
        }
        for (String string : illegalChars) {
            argumentsList.add(Arguments.of((Object[])new Object[]{string + " Some Legal Characters"}));
        }
        return argumentsList.stream();
    }

    public static Stream<Arguments> legalIdentifiers() {
        int i;
        LinkedList<Arguments> args = new LinkedList<Arguments>();
        String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lower = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT);
        String digits = "0123456789";
        String validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + lower + digits + "-_";
        for (i = 0; i < validChars.length(); ++i) {
            args.add(Arguments.of((Object[])new Object[]{"" + validChars.charAt(i)}));
        }
        for (i = 0; i < 100; ++i) {
            args.add(Arguments.of((Object[])new Object[]{TestBase.randomString(RAND, validChars, 12)}));
        }
        return args.stream();
    }
}

